/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components.grid;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.tacos.ajax.components.grid.GridColumn;

public class GridColumnModel {
    private List columns = null;
    private Map columnsMapping = new HashMap();

    public GridColumnModel(List columns) {
        if (columns == null) {
            throw new IllegalArgumentException("Columns list is null");
        }
        this.columns = columns;
        this.setColumnsMapping();
    }

    private void setColumnsMapping() {
        if (this.columns == null) {
            return;
        }
        int index = 0;
        Iterator it = this.columns.iterator();
        while (it.hasNext()) {
            GridColumn col = (GridColumn)it.next();
            col.setIndex(new Integer(index));
            this.columnsMapping.put(col.getName(), col);
            ++index;
        }
    }

    public List getColumns() {
        return this.columns;
    }

    public GridColumn getColumnByName(String name) {
        return (GridColumn)this.columnsMapping.get(name);
    }

    public String getColumnTypeByName(String name) {
        return this.getColumnByName(name).getDataType();
    }
}

