/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components.palette;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.tacos.ajax.components.palette.PaletteOption;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;

public class PaletteColumn
implements IRender {
    private String name;
    private String clientId;
    private int rows;
    private List options = new ArrayList();

    public PaletteColumn(String name, String clientId, int rows) {
        this.name = name;
        this.clientId = clientId;
        this.rows = rows;
    }

    public void addOption(PaletteOption option) {
        this.options.add(option);
    }

    public void sortByValue() {
        Collections.sort(this.options, new ValueComparator());
    }

    public void sortByLabel() {
        Collections.sort(this.options, new LabelComparator());
    }

    public void render(IMarkupWriter writer, IRequestCycle cycle) {
        writer.begin("select");
        writer.attribute("multiple", "multiple");
        writer.attribute("name", this.name);
        if (this.clientId != null) {
            writer.attribute("id", this.clientId);
        }
        writer.attribute("size", this.rows);
        writer.println();
        int count = this.options.size();
        for (int i = 0; i < count; ++i) {
            PaletteOption o = (PaletteOption)this.options.get(i);
            o.render(writer, cycle);
        }
        writer.end();
    }

    private static class LabelComparator
    implements Comparator {
        private LabelComparator() {
        }

        public int compare(Object o1, Object o2) {
            PaletteOption option1 = (PaletteOption)o1;
            PaletteOption option2 = (PaletteOption)o2;
            return option1.getLabel().compareTo(option2.getLabel());
        }
    }

    private static class ValueComparator
    implements Comparator {
        private ValueComparator() {
        }

        public int compare(Object o1, Object o2) {
            PaletteOption option1 = (PaletteOption)o1;
            PaletteOption option2 = (PaletteOption)o2;
            return option1.getValue().compareTo(option2.getValue());
        }
    }
}

