/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.Stack;
import net.sf.tacos.ajax.AjaxDirectServiceParameter;
import net.sf.tacos.ajax.AjaxWebRequest;
import net.sf.tacos.ajax.components.PartialRenderBlock;
import net.sf.tacos.ajax.components.tree.ITreeManager;
import net.sf.tacos.ajax.components.tree.TreeIterator;
import net.sf.tacos.ajax.components.tree.TreeManager;
import net.sf.tacos.model.IKeyProvider;
import net.sf.tacos.model.ITreeContentProvider;
import net.sf.tacos.model.IdentityKeyProvider;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IDirect;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.bean.EvenOdd;
import org.apache.tapestry.components.Any;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.listener.ListenerInvoker;

public abstract class Tree
extends BaseComponent
implements PartialRenderBlock,
IDirect {
    private static final Log log = LogFactory.getLog((Class)Tree.class);
    private static final IKeyProvider identityKeyProvider = new IdentityKeyProvider();
    private TreeIterator treeIterator;
    private Stack parts;

    public IKeyProvider getIdentityKeyProvider() {
        return identityKeyProvider;
    }

    public TreeIterator getTreeIterator() {
        return this.treeIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        block12: {
            if (!cycle.isRewinding() && this.isDelayedLoad() && !this.getAjaxWebRequest().isValidRequest()) {
                Any anyContainer = (Any)this.getComponent("treeDiv");
                writer.begin(anyContainer.getElement());
                super.renderInformalParameters(writer, cycle);
                writer.end();
                String treeId = this.getId();
                if (this.isParameterBound("id")) {
                    treeId = (String)this.getBinding("id").getObject();
                }
                AjaxDirectServiceParameter dsp = new AjaxDirectServiceParameter((IDirect)this, new Object[0], new String[]{treeId}, false);
                HashMap<String, String> parms = new HashMap<String, String>();
                parms.put("treeId", treeId);
                parms.put("url", StringEscapeUtils.escapeJavaScript((String)this.getAjaxEngine().getLink(true, (Object)dsp).getAbsoluteURL()));
                if (this.getLoadElement() != null) {
                    parms.put("loadElement", this.getLoadElement());
                }
                PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)this);
                this.getScript().execute(cycle, (IScriptProcessor)pageRenderSupport, parms);
                return;
            }
            this.treeIterator = new TreeIter();
            this.parts = new Stack();
            super.renderComponent(writer, cycle);
            Object var9_8 = null;
            try {
                while (!this.parts.isEmpty()) {
                    String partId = this.parts.pop().toString();
                    if (this.getAjaxWebRequest().isValidRequest() && this.getAjaxWebRequest().getResponseBuilder().componentWriterExists(partId)) {
                        this.getAjaxWebRequest().getResponseBuilder().getComponentWriter(partId).end();
                        continue;
                    }
                    writer.end();
                }
                break block12;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            {
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    while (!this.parts.isEmpty()) {
                        String partId = this.parts.pop().toString();
                        if (this.getAjaxWebRequest().isValidRequest() && this.getAjaxWebRequest().getResponseBuilder().componentWriterExists(partId)) {
                            this.getAjaxWebRequest().getResponseBuilder().getComponentWriter(partId).end();
                            continue;
                        }
                        writer.end();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                this.treeIterator = null;
                this.parts = null;
                throw throwable;
            }
        }
        this.treeIterator = null;
        this.parts = null;
    }

    public void expansion(IRequestCycle cycle) {
        Object[] params = cycle.getListenerParameters();
        Serializable key = (Serializable)params[0];
        Boolean expanded = (Boolean)params[1];
        this.getManager().setExpandedKey(key, expanded);
        this.setState(this.getState());
    }

    public void contentExpansion(IRequestCycle cycle) {
        this.expansion(cycle);
        if (this.getLinkListener() == null) {
            log.warn((Object)"contentExpansion() called but no linkListener was specified on the tree. Use the linkListener parameter if you want your page/component to be invoked as well.");
            return;
        }
        this.getListenerInvoker().invokeListener(this.getLinkListener(), (IComponent)this, cycle);
    }

    public boolean isExpanded(Object element) {
        return this.getManager().isExpanded(element);
    }

    private Collection sorted(Collection elements) {
        Comparator comp = this.getSorter();
        if (comp == null) {
            return elements;
        }
        ArrayList l = new ArrayList(elements);
        Collections.sort(l, comp);
        return l;
    }

    public ITreeManager getManager() {
        return new TreeManager(this.getState(), this.getContentProvider(), this.getKeyProvider());
    }

    public void beforeRenderBody(IMarkupWriter writer, IRequestCycle cycle, Serializable partId, boolean isRendering) {
        if (this.treeIterator.getDepth() <= this.treeIterator.getPreviousDepth() && !this.parts.isEmpty()) {
            int pops = 1;
            if (this.treeIterator.getDepth() < this.treeIterator.getPreviousDepth()) {
                pops = this.treeIterator.getPreviousDepth() - this.treeIterator.getDepth();
                ++pops;
            }
            while (pops > 0 && !this.parts.isEmpty()) {
                Serializable id = (Serializable)this.parts.pop();
                if (isRendering) {
                    if (this.getAjaxWebRequest().isValidRequest() && this.getAjaxWebRequest().containsComponentId(id.toString())) {
                        this.getAjaxWebRequest().getResponseBuilder().getComponentWriter(id.toString()).end();
                    } else {
                        IMarkupWriter pwriter = this.findParentPart();
                        if (pwriter != null) {
                            pwriter.end();
                        } else {
                            writer.end();
                        }
                    }
                }
                --pops;
            }
        }
        if (isRendering) {
            writer.begin("div");
            writer.attribute("id", partId.toString());
            if (this.isRowStyleInOuterDiv() && this.getRowStyle() != null) {
                writer.attribute("class", this.getRowStyle().getNext());
            } else if (this.getPartialBlockClass() != null) {
                writer.attribute("class", this.getPartialBlockClass());
            }
            this.parts.push(partId.toString());
        }
    }

    public void incrementNonRenderBlock() {
        if (this.getRowStyle() != null) {
            this.getRowStyle().getNext();
        }
        this.beforeRenderBody(null, null, this.getKeyProvider().getKey(this.getValue()), false);
    }

    public IMarkupWriter getPartWriter(Serializable partId) {
        String partStr = partId.toString();
        IMarkupWriter ret = null;
        if (this.treeIterator.getDepth() < this.treeIterator.getPreviousDepth() && !this.parts.isEmpty() && this.parts.size() - 1 > this.treeIterator.getPreviousDepth() - this.treeIterator.getDepth()) {
            ret = this.findParentPart();
        } else if (this.treeIterator.getDepth() > this.treeIterator.getPreviousDepth() && !this.parts.isEmpty()) {
            ret = this.findParentPart();
        } else if (this.treeIterator.getDepth() == this.treeIterator.getPreviousDepth() && this.parts.size() > 1) {
            ret = this.findParentPart();
        }
        return ret;
    }

    private IMarkupWriter findParentPart() {
        if (!this.getAjaxWebRequest().isValidRequest()) {
            return null;
        }
        IMarkupWriter ret = null;
        Serializable[] partIds = this.parts.toArray(new Serializable[this.parts.size()]);
        for (int i = 0; i < partIds.length; ++i) {
            if (!this.getAjaxWebRequest().containsComponentId(partIds[i].toString())) continue;
            return this.getAjaxWebRequest().getResponseBuilder().getComponentWriter(partIds[i].toString());
        }
        return ret;
    }

    public PartialRenderBlock getPartialTreeBlock() {
        return this;
    }

    public boolean isStateful() {
        return true;
    }

    public void trigger(IRequestCycle cycle) {
    }

    public abstract IScript getScript();

    public abstract IEngineService getAjaxEngine();

    public abstract AjaxWebRequest getAjaxWebRequest();

    public abstract Object getValue();

    public abstract Set getState();

    public abstract void setState(Set var1);

    public abstract ITreeContentProvider getContentProvider();

    public abstract IKeyProvider getKeyProvider();

    public abstract Comparator getSorter();

    public abstract EvenOdd getRowStyle();

    public abstract boolean isRowStyleInOuterDiv();

    public abstract String getPartialBlockClass();

    public abstract ListenerInvoker getListenerInvoker();

    public abstract IActionListener getLinkListener();

    public abstract boolean isDelayedLoad();

    public abstract String getLoadElement();

    private final class TreeIter
    extends TreeIterator {
        private TreeIter() {
            super(Tree.this.sorted(Tree.this.getContentProvider().getElements()));
        }

        protected Collection getChildren(Object node) {
            if (!Tree.this.isExpanded(node)) {
                return Collections.EMPTY_LIST;
            }
            Collection coll = Tree.this.getContentProvider().getChildren(node);
            return Tree.this.sorted(coll);
        }
    }
}

