/**
 * Dates formatter. You can specify the date format to use, and other
 * options like ignoring separators, etc. Defaults to American dates.
 *
 * Leonardo Quijano
 * Feb 2006
 */
dojo.require("dojo.validate");
dojo.require("dojo.math");
dojo.require("dojo.string");
dojo.require("dojo.event.browser");
dojo.require("dojo.date");

function DateFormatter() {
    /* Create a flags object. */
    this.flags = new Object();
    this.flags.format = "%m/%d/%Y";     // Date format.
    this.flags.ignoreSeparators = true; // Let users enter dates like "04052001".
    this.flags.separator = "/";         // Date separator.
    this.flags.amSymbol = "AM";         // AM symbol.
    this.flags.pmSymbol = "PM";         // PM symbol.

    /* Formats dates. */
    this.format = function(str) {
        var date = parseLocalizedDate(str, this.flags);
        if(date == null) {
            return str;
        }
        return dojo.date.format(date, this.flags.format);
    };

    /* Validates dates using the specified flags. */
    this.validate = function(str) {
        var date = parseLocalizedDate(str, this.flags);
        return (date != null);
    };

    this.isAllowed = function(code, previousStr, nextStr) {
        return true;
    };
}
