/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtpl;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Jtpl {
    private HashMap blocks = new HashMap();
    private HashMap parsedBlocks = new HashMap();
    private HashMap subBlocks = new HashMap();
    private HashMap vars = new HashMap();
    private boolean failSilently = false;
    private boolean implicitMain = false;

    public Jtpl(String fileName) throws IOException {
        this(new File(fileName));
        this.failSilently = true;
    }

    public Jtpl(File file) throws IOException {
        FileReader fr = new FileReader(file);
        String fileText = this.readFile(fr);
        this.makeTree(fileText);
    }

    public Jtpl(Reader template) throws IOException {
        String fileText = this.readFile(template);
        this.makeTree(fileText);
    }

    public void assign(String varName, String varData) {
        this.vars.put(varName, varData);
    }

    public String out() {
        Object main;
        if (this.implicitMain) {
            this.parse("main");
        }
        if ((main = this.parsedBlocks.get("main")) == null) {
            throw new IllegalStateException("'main' block not parsed");
        }
        return main.toString();
    }

    public void parse(String blockName) throws IllegalArgumentException {
        String copy;
        block9: {
            copy = "";
            if (this.implicitMain && !"main".equals(blockName) && !blockName.startsWith("main.")) {
                blockName = "main." + blockName;
            }
            try {
                copy = this.blocks.get(blockName).toString();
            }
            catch (NullPointerException e) {
                if (this.failSilently) break block9;
                throw new IllegalArgumentException("Block '" + blockName + "' not found." + " Matches " + this.locateBlock(blockName));
            }
        }
        Pattern pattern = Pattern.compile("\\{([\\w\\.]+)\\}");
        Matcher matcher = pattern.matcher(copy);
        pattern = Pattern.compile("_BLOCK_\\.(.+)");
        while (matcher.find()) {
            String match = matcher.group(1);
            Matcher matcher2 = pattern.matcher(match);
            if (matcher2.find()) {
                if (this.parsedBlocks.containsKey(matcher2.group(1))) {
                    copy = copy.replaceFirst("\\{" + match + "\\}", this.escape(this.parsedBlocks.get(matcher2.group(1)).toString()));
                    continue;
                }
                copy = copy.replaceFirst("\\{" + match + "\\}", "");
                continue;
            }
            if (!this.vars.containsKey(match)) continue;
            copy = copy.replaceFirst("\\{" + match + "\\}", this.escape(this.vars.get(match).toString()));
        }
        if (this.parsedBlocks.containsKey(blockName)) {
            this.parsedBlocks.put(blockName, this.parsedBlocks.get(blockName) + copy);
        } else {
            this.parsedBlocks.put(blockName, copy);
        }
        if (this.subBlocks.containsKey(blockName)) {
            this.parsedBlocks.put(this.subBlocks.get(blockName), "");
        }
    }

    protected String escape(String replacement) {
        return replacement.replace("\\", "\\\\").replace("$", "\\$");
    }

    protected Set locateBlock(String blockName) {
        HashSet matches = new HashSet();
        Iterator it = this.blocks.keySet().iterator();
        while (it.hasNext()) {
            Object b = it.next();
            if (!b.toString().endsWith('.' + blockName)) continue;
            matches.add(b);
        }
        return matches;
    }

    private String readFile(Reader fr) throws IOException {
        int c;
        StringBuffer content = new StringBuffer();
        while ((c = fr.read()) != -1) {
            content.append((char)c);
        }
        fr.close();
        return content.toString();
    }

    private void makeTree(String fileText) {
        if (!Pattern.compile(".*<!--\\s*BEGIN\\s*:\\s*main\\s*-->.*", 32).matcher(fileText).matches()) {
            this.implicitMain = true;
            fileText = "<!-- BEGIN: main -->" + fileText + "<!-- END: main -->";
        }
        Pattern pattern = Pattern.compile("<!--\\s*(BEGIN|END)\\s*:\\s*(\\w+)\\s*-->(.*?)(?=(?:<!--\\s*(?:BEGIN|END)\\s*:\\s*\\w+\\s*-->)|(?:\\s*$))", 34);
        Matcher matcher = pattern.matcher(fileText);
        ArrayList<String> blockNames = new ArrayList<String>();
        String parentName = "";
        int lastlength = 0;
        while (matcher.find()) {
            String after = matcher.group(3);
            if (lastlength == 0 || fileText.charAt(matcher.start() - 1) == '\n') {
                after = after.replaceFirst("^\\r?\\n", "");
            }
            lastlength = after.length();
            if (matcher.group(1).toUpperCase().equals("BEGIN")) {
                parentName = this.implode(blockNames);
                blockNames.add(matcher.group(2));
                String currentBlockName = this.implode(blockNames);
                if (this.blocks.containsKey(currentBlockName)) {
                    this.blocks.put(currentBlockName, this.blocks.get(currentBlockName) + after);
                } else {
                    this.blocks.put(currentBlockName, after);
                }
                if (this.blocks.containsKey(parentName)) {
                    this.blocks.put(parentName, this.blocks.get(parentName) + "{_BLOCK_." + currentBlockName + "}");
                } else {
                    this.blocks.put(parentName, "{_BLOCK_." + currentBlockName + "}");
                }
                this.subBlocks.put(parentName, currentBlockName);
                this.subBlocks.put(currentBlockName, "");
                continue;
            }
            if (!matcher.group(1).toUpperCase().equals("END")) continue;
            blockNames.remove(blockNames.size() - 1);
            parentName = this.implode(blockNames);
            if (this.blocks.containsKey(parentName)) {
                this.blocks.put(parentName, this.blocks.get(parentName) + after);
                continue;
            }
            this.blocks.put(parentName, after);
        }
    }

    private String implode(ArrayList al) {
        String ret = "";
        for (int i = 0; al.size() > i; ++i) {
            if (i != 0) {
                ret = ret + ".";
            }
            ret = ret + al.get(i);
        }
        return ret;
    }
}

