/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.buffer.TimedBuffer;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;
import org.jboss.logging.Logger;

public abstract class AbstractSequentialFileFactory
implements SequentialFileFactory {
    private static final Logger logger = Logger.getLogger(AbstractSequentialFileFactory.class);
    protected static final int EXECUTOR_TIMEOUT = 60;
    protected final File journalDir;
    protected final TimedBuffer timedBuffer;
    protected final int bufferSize;
    protected final long bufferTimeout;
    protected final int maxIO;
    protected boolean dataSync = true;
    protected volatile int alignment = -1;
    protected final IOCriticalErrorListener critialErrorListener;
    protected final CriticalAnalyzer criticalAnalyzer;
    protected ExecutorService writeExecutor;

    protected AbstractSequentialFileFactory(File journalDir, boolean buffered, int bufferSize, int bufferTimeout, int maxIO, boolean logRates, IOCriticalErrorListener criticalErrorListener, CriticalAnalyzer criticalAnalyzer) {
        this.journalDir = journalDir;
        if (criticalAnalyzer == null) {
            criticalAnalyzer = EmptyCriticalAnalyzer.getInstance();
        }
        this.criticalAnalyzer = criticalAnalyzer;
        if (buffered && bufferTimeout > 0) {
            this.timedBuffer = new TimedBuffer(criticalAnalyzer, bufferSize, bufferTimeout, logRates);
            criticalAnalyzer.add((CriticalComponent)this.timedBuffer);
        } else {
            this.timedBuffer = null;
        }
        this.bufferSize = bufferSize;
        this.bufferTimeout = bufferTimeout;
        this.critialErrorListener = criticalErrorListener;
        this.maxIO = maxIO;
    }

    @Override
    public CriticalAnalyzer getCriticalAnalyzer() {
        return this.criticalAnalyzer;
    }

    @Override
    public long getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public int getAlignment() {
        if (this.alignment < 0) {
            this.alignment = 1;
        }
        return this.alignment;
    }

    @Override
    public AbstractSequentialFileFactory setAlignment(int alignment) {
        this.alignment = alignment;
        return this;
    }

    @Override
    public SequentialFileFactory setDatasync(boolean enabled) {
        this.dataSync = enabled;
        return this;
    }

    @Override
    public boolean isDatasync() {
        return this.dataSync;
    }

    @Override
    public void stop() {
        if (this.timedBuffer != null) {
            this.timedBuffer.stop();
        }
        if (this.isSupportsCallbacks() && this.writeExecutor != null) {
            this.writeExecutor.shutdown();
            try {
                if (!this.writeExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    ActiveMQJournalLogger.LOGGER.timeoutOnWriterShutdown(new Exception("trace"));
                }
            }
            catch (InterruptedException e) {
                throw new ActiveMQInterruptedException((Throwable)e);
            }
        }
    }

    @Override
    public File getDirectory() {
        return this.journalDir;
    }

    @Override
    public void start() {
        if (this.timedBuffer != null) {
            this.timedBuffer.start();
        }
        if (this.isSupportsCallbacks()) {
            this.writeExecutor = Executors.newSingleThreadExecutor((ThreadFactory)AccessController.doPrivileged(new PrivilegedAction<ActiveMQThreadFactory>(){

                @Override
                public ActiveMQThreadFactory run() {
                    return new ActiveMQThreadFactory("ActiveMQ-Asynchronous-Persistent-Writes" + System.identityHashCode(this), true, AbstractSequentialFileFactory.class.getClassLoader());
                }
            }));
        }
    }

    @Override
    public int getMaxIO() {
        return this.maxIO;
    }

    @Override
    public void onIOError(Exception exception, String message, SequentialFile file) {
        if (this.critialErrorListener != null) {
            this.critialErrorListener.onIOException(exception, message, file);
        } else {
            logger.warn((Object)"Critical IO Error Called.  No Critical IO Error Handler Registered");
        }
    }

    @Override
    public void activateBuffer(SequentialFile file) {
        if (this.timedBuffer != null) {
            file.setTimedBuffer(this.timedBuffer);
        }
    }

    @Override
    public void flush() {
        if (this.timedBuffer != null) {
            this.timedBuffer.flush();
        }
    }

    @Override
    public void deactivateBuffer() {
        if (this.timedBuffer != null) {
            this.timedBuffer.flush();
            this.timedBuffer.setObserver(null);
        }
    }

    @Override
    public void releaseBuffer(ByteBuffer buffer) {
    }

    @Override
    public void createDirs() throws Exception {
        boolean ok = this.journalDir.mkdirs();
        if (!ok) {
            throw new IOException("Failed to create directory " + this.journalDir);
        }
    }

    @Override
    public List<String> listFiles(final String extension) throws Exception {
        FilenameFilter fnf = new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith("." + extension);
            }
        };
        String[] fileNames = this.journalDir.list(fnf);
        if (fileNames == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(fileNames);
    }
}

