/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.service.extensions.xa.recovery;

import java.io.Serializable;
import java.util.Locale;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.service.extensions.xa.recovery.ActiveMQXARecoveryLogger;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.w3c.dom.Node;

public class ActiveMQXARecoveryLogger_$logger
extends DelegatingBasicLogger
implements ActiveMQXARecoveryLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ActiveMQXARecoveryLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String serverRunningCachedCommand = "AMQ121003: JMS Server Manager Running cached command for {0}";
    private static final String serverCachingCommand = "AMQ121004: JMS Server Manager Caching command for {0} since the JMS Server is not active.";
    private static final String invalidHostForConnector = "AMQ122005: Invalid \"host\" value \"0.0.0.0\" detected for \"{0}\" connector. Switching to \"{1}\". If this new address is incorrect please manually configure the connector to use the proper one.";
    private static final String noQueueOnTopic = "AMQ122007: Queue {0} does not exist on the topic {1}. It was deleted manually probably.";
    private static final String recoveryConnectFailed = "AMQ122008: XA Recovery can not connect to any broker on recovery {0}";
    private static final String jndiUnbindError = "AMQ122011: error unbinding {0} from JNDI";
    private static final String jmsServerError = "AMQ122012: JMS Server Manager error";
    private static final String xaRecoverError = "AMQ122013: Error in XA Recovery recover";
    private static final String xaRecoverConnectionError = "AMQ122014: Notified of connection failure in xa recovery connectionFactory for provider {0} will attempt reconnect on next pass";
    private static final String xaRecoverAutoConnectionError = "AMQ122015: Can not connect to {0} on auto-generated resource recovery";
    private static final String xaRecoveryError = "AMQ122016: Error in XA Recovery";
    private static final String failedToCorrectHost = "AMQ122017: Tried to correct invalid \"host\" value \"0.0.0.0\" for \"{0}\" connector, but received an exception.";
    private static final String xaRecoveryStartError = "AMQ122018: Could not start recovery discovery on {0}, we will retry every recovery scan until the server is available";
    private static final String jmsConfigMissingKey = "AMQ124000: key attribute missing for JMS configuration {0}";
    private static final String jmsDeployerStartError = "AMQ124002: Failed to start JMS deployer";

    public ActiveMQXARecoveryLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void serverRunningCachedCommand(Runnable run) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.serverRunningCachedCommand$str(), (Object)run);
    }

    protected String serverRunningCachedCommand$str() {
        return serverRunningCachedCommand;
    }

    @Override
    public final void serverCachingCommand(Object runnable) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.serverCachingCommand$str(), runnable);
    }

    protected String serverCachingCommand$str() {
        return serverCachingCommand;
    }

    @Override
    public final void invalidHostForConnector(String name, String newHost) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.invalidHostForConnector$str(), (Object)name, (Object)newHost);
    }

    protected String invalidHostForConnector$str() {
        return invalidHostForConnector;
    }

    @Override
    public final void noQueueOnTopic(String queueName, String name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.noQueueOnTopic$str(), (Object)queueName, (Object)name);
    }

    protected String noQueueOnTopic$str() {
        return noQueueOnTopic;
    }

    @Override
    public final void recoveryConnectFailed(String s) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.recoveryConnectFailed$str(), (Object)s);
    }

    protected String recoveryConnectFailed$str() {
        return recoveryConnectFailed;
    }

    @Override
    public final void jndiUnbindError(Exception e, String key) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.jndiUnbindError$str(), (Object)key);
    }

    protected String jndiUnbindError$str() {
        return jndiUnbindError;
    }

    @Override
    public final void jmsServerError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.jmsServerError$str(), new Object[0]);
    }

    protected String jmsServerError$str() {
        return jmsServerError;
    }

    @Override
    public final void xaRecoverError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.xaRecoverError$str(), new Object[0]);
    }

    protected String xaRecoverError$str() {
        return xaRecoverError;
    }

    @Override
    public final void xaRecoverConnectionError(Exception e, ClientSessionFactory csf) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.xaRecoverConnectionError$str(), (Object)csf);
    }

    protected String xaRecoverConnectionError$str() {
        return xaRecoverConnectionError;
    }

    @Override
    public final void xaRecoverAutoConnectionError(Throwable e, XARecoveryConfig csf) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.xaRecoverAutoConnectionError$str(), (Object)csf);
    }

    protected String xaRecoverAutoConnectionError$str() {
        return xaRecoverAutoConnectionError;
    }

    @Override
    public final void xaRecoveryError(Exception e) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)e, this.xaRecoveryError$str(), new Object[0]);
    }

    protected String xaRecoveryError$str() {
        return xaRecoveryError;
    }

    @Override
    public final void failedToCorrectHost(Exception e, String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToCorrectHost$str(), (Object)name);
    }

    protected String failedToCorrectHost$str() {
        return failedToCorrectHost;
    }

    @Override
    public final void xaRecoveryStartError(XARecoveryConfig e) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.xaRecoveryStartError$str(), (Object)e);
    }

    protected String xaRecoveryStartError$str() {
        return xaRecoveryStartError;
    }

    @Override
    public final void jmsConfigMissingKey(Node e) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.jmsConfigMissingKey$str(), (Object)e);
    }

    protected String jmsConfigMissingKey$str() {
        return jmsConfigMissingKey;
    }

    @Override
    public final void jmsDeployerStartError(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.jmsDeployerStartError$str(), new Object[0]);
    }

    protected String jmsDeployerStartError$str() {
        return jmsDeployerStartError;
    }
}

