/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.mqtt;

import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.receiver.Receiver;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!4Q!\u0001\u0002\u0001\t1\u0011\u0011$T)U)\nKH/Z!se\u0006L\b+Y5s%\u0016\u001cW-\u001b<fe*\u00111\u0001B\u0001\u0005[F$HO\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0004\u001dE\u0019R\"A\b\u000b\u0005A!\u0011\u0001\u0003:fG\u0016Lg/\u001a:\n\u0005Iy!\u0001\u0003*fG\u0016Lg/\u001a:\u0011\tQ9\u0012\u0004I\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1A+\u001e9mKJ\u0002\"AG\u000f\u000f\u0005QY\u0012B\u0001\u000f\u0016\u0003\u0019\u0001&/\u001a3fM&\u0011ad\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005q)\u0002c\u0001\u000b\"G%\u0011!%\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003)\u0011J!!J\u000b\u0003\t\tKH/\u001a\u0005\tO\u0001\u0011\t\u0011)A\u00053\u0005I!M]8lKJ,&\u000f\\\u0002\u0001\u0011!Q\u0003A!A!\u0002\u0013Y\u0013A\u0002;pa&\u001c7\u000fE\u0002\u0015CeA\u0011\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u001b\u0002\u0019M$xN]1hK2+g/\u001a7\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E2\u0011aB:u_J\fw-Z\u0005\u0003gA\u0012Ab\u0015;pe\u0006<W\rT3wK2L!!L\t\t\u0011Y\u0002!\u0011!Q\u0001\n]\n\u0001b\u00197jK:$\u0018\n\u001a\t\u0004)aJ\u0012BA\u001d\u0016\u0005\u0019y\u0005\u000f^5p]\"A1\b\u0001B\u0001B\u0003%q'\u0001\u0005vg\u0016\u0014h.Y7f\u0011!i\u0004A!A!\u0002\u00139\u0014\u0001\u00039bgN<xN\u001d3\t\u0011}\u0002!\u0011!Q\u0001\n\u0001\u000bAb\u00197fC:\u001cVm]:j_:\u00042\u0001\u0006\u001dB!\t!\")\u0003\u0002D+\t9!i\\8mK\u0006t\u0007\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\u0002\u0007E|7\u000fE\u0002\u0015q\u001d\u0003\"\u0001\u0006%\n\u0005%+\"aA%oi\"A1\n\u0001B\u0001B\u0003%a)A\td_:tWm\u0019;j_:$\u0016.\\3pkRD\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IAR\u0001\u0012W\u0016,\u0007/\u00117jm\u0016Le\u000e^3sm\u0006d\u0007\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\u0002\u00175\fH\u000f\u001e,feNLwN\u001c\u0005\u0006#\u0002!\tAU\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019M+fk\u0016-Z5ncVLX0\u0011\u0005Q\u0003Q\"\u0001\u0002\t\u000b\u001d\u0002\u0006\u0019A\r\t\u000b)\u0002\u0006\u0019A\u0016\t\u000b5\u0002\u0006\u0019\u0001\u0018\t\u000bY\u0002\u0006\u0019A\u001c\t\u000bm\u0002\u0006\u0019A\u001c\t\u000bu\u0002\u0006\u0019A\u001c\t\u000b}\u0002\u0006\u0019\u0001!\t\u000b\u0015\u0003\u0006\u0019\u0001$\t\u000b-\u0003\u0006\u0019\u0001$\t\u000b5\u0003\u0006\u0019\u0001$\t\u000b=\u0003\u0006\u0019\u0001$\t\u000b\u0005\u0004A\u0011\u00012\u0002\r=t7\u000b^8q)\u0005\u0019\u0007C\u0001\u000be\u0013\t)WC\u0001\u0003V]&$\b\"B4\u0001\t\u0003\u0011\u0017aB8o'R\f'\u000f\u001e")
public class MQTTByteArrayPairReceiver
extends Receiver<Tuple2<String, byte[]>> {
    private final String brokerUrl;
    private final String[] topics;
    private final Option<String> clientId;
    private final Option<String> username;
    private final Option<String> password;
    private final Option<Object> cleanSession;
    public final Option<Object> org$apache$spark$streaming$mqtt$MQTTByteArrayPairReceiver$$qos;
    private final Option<Object> connectionTimeout;
    private final Option<Object> keepAliveInterval;
    private final Option<Object> mqttVersion;

    public void onStop() {
    }

    public void onStart() {
        MemoryPersistence persistence = new MemoryPersistence();
        MqttClient client = new MqttClient(this.brokerUrl, (String)this.clientId.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return MqttClient.generateClientId();
            }
        }), (MqttClientPersistence)persistence);
        MqttConnectOptions mqttConnectionOptions = new MqttConnectOptions();
        if (this.username.isDefined() && this.password.isDefined()) {
            mqttConnectionOptions.setUserName((String)this.username.get());
            mqttConnectionOptions.setPassword(((String)this.password.get()).toCharArray());
        }
        mqttConnectionOptions.setCleanSession(BoxesRunTime.unboxToBoolean((Object)this.cleanSession.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        })));
        if (this.connectionTimeout.isDefined()) {
            mqttConnectionOptions.setConnectionTimeout(BoxesRunTime.unboxToInt((Object)this.connectionTimeout.get()));
        }
        if (this.keepAliveInterval.isDefined()) {
            mqttConnectionOptions.setKeepAliveInterval(BoxesRunTime.unboxToInt((Object)this.keepAliveInterval.get()));
        }
        if (this.mqttVersion.isDefined()) {
            mqttConnectionOptions.setMqttVersion(BoxesRunTime.unboxToInt((Object)this.mqttVersion.get()));
        }
        MqttCallback callback = new MqttCallback(this){
            private final /* synthetic */ MQTTByteArrayPairReceiver $outer;

            public void messageArrived(String topic, MqttMessage message) {
                this.$outer.store(new Tuple2((Object)topic, (Object)message.getPayload()));
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
            }

            public void connectionLost(Throwable cause) {
                this.$outer.restart("Connection lost ", cause);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        client.setCallback(callback);
        client.connect(mqttConnectionOptions);
        boolean i = false;
        int[] qosArray = (int[])Array$.MODULE$.ofDim(this.topics.length, ClassTag$.MODULE$.Int());
        Predef$.MODULE$.intArrayOps(qosArray).indices().foreach$mVc$sp((Function1)new Serializable(this, qosArray){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MQTTByteArrayPairReceiver $outer;
            private final int[] qosArray$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.qosArray$1[i] = BoxesRunTime.unboxToInt((Object)this.$outer.org$apache$spark$streaming$mqtt$MQTTByteArrayPairReceiver$$qos.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 1;
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.qosArray$1 = qosArray$1;
            }
        });
        client.subscribe(this.topics, qosArray);
    }

    public MQTTByteArrayPairReceiver(String brokerUrl, String[] topics, StorageLevel storageLevel, Option<String> clientId, Option<String> username, Option<String> password, Option<Object> cleanSession, Option<Object> qos, Option<Object> connectionTimeout, Option<Object> keepAliveInterval, Option<Object> mqttVersion) {
        this.brokerUrl = brokerUrl;
        this.topics = topics;
        this.clientId = clientId;
        this.username = username;
        this.password = password;
        this.cleanSession = cleanSession;
        this.org$apache$spark$streaming$mqtt$MQTTByteArrayPairReceiver$$qos = qos;
        this.connectionTimeout = connectionTimeout;
        this.keepAliveInterval = keepAliveInterval;
        this.mqttVersion = mqttVersion;
        super(storageLevel);
    }
}

