/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.bookkeeper.bookie.LedgerEntryPage;

public class BufferedChannel {
    ByteBuffer writeBuffer;
    ByteBuffer readBuffer;
    private FileChannel bc;
    long position;
    int capacity;
    long readBufferStartPosition;
    long writeBufferStartPosition;

    public BufferedChannel(FileChannel bc, int capacity) throws IOException {
        this.bc = bc;
        this.capacity = capacity;
        this.writeBufferStartPosition = this.position = bc.position();
    }

    FileChannel getFileChannel() {
        return this.bc;
    }

    public synchronized int write(ByteBuffer src) throws IOException {
        int copied = 0;
        if (this.writeBuffer == null) {
            this.writeBuffer = ByteBuffer.allocateDirect(this.capacity);
        }
        while (src.remaining() > 0) {
            int truncated = 0;
            if (this.writeBuffer.remaining() < src.remaining()) {
                truncated = src.remaining() - this.writeBuffer.remaining();
                src.limit(src.limit() - truncated);
            }
            copied += src.remaining();
            this.writeBuffer.put(src);
            src.limit(src.limit() + truncated);
            if (this.writeBuffer.remaining() != 0) continue;
            this.writeBuffer.flip();
            this.bc.write(this.writeBuffer);
            this.writeBuffer.clear();
            this.writeBufferStartPosition = this.bc.position();
        }
        this.position += (long)copied;
        return copied;
    }

    public long position() {
        return this.position;
    }

    public long size() throws IOException {
        return this.bc.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(boolean sync) throws IOException {
        BufferedChannel bufferedChannel = this;
        synchronized (bufferedChannel) {
            if (this.writeBuffer == null) {
                return;
            }
            this.writeBuffer.flip();
            this.bc.write(this.writeBuffer);
            this.writeBuffer.clear();
            this.writeBufferStartPosition = this.bc.position();
        }
        if (sync) {
            this.bc.force(false);
        }
    }

    public synchronized int read(ByteBuffer buff, long pos) throws IOException {
        if (this.readBuffer == null) {
            this.readBuffer = ByteBuffer.allocateDirect(this.capacity);
            this.readBufferStartPosition = Long.MIN_VALUE;
        }
        long prevPos = pos;
        while (buff.remaining() > 0) {
            ByteBuffer src;
            long bytesToCopy;
            long positionInBuffer;
            if (this.writeBuffer != null && this.writeBufferStartPosition <= pos) {
                positionInBuffer = pos - this.writeBufferStartPosition;
                bytesToCopy = (long)this.writeBuffer.position() - positionInBuffer;
                if (bytesToCopy > (long)buff.remaining()) {
                    bytesToCopy = buff.remaining();
                }
                if (bytesToCopy == 0L) {
                    throw new IOException("Read past EOF");
                }
                src = this.writeBuffer.duplicate();
                src.position((int)positionInBuffer);
                src.limit((int)(positionInBuffer + bytesToCopy));
                buff.put(src);
                pos += bytesToCopy;
                continue;
            }
            if (this.writeBuffer == null && this.writeBufferStartPosition <= pos) break;
            if (this.readBufferStartPosition <= pos && pos < this.readBufferStartPosition + (long)this.readBuffer.capacity()) {
                positionInBuffer = pos - this.readBufferStartPosition;
                bytesToCopy = (long)this.readBuffer.capacity() - positionInBuffer;
                if (bytesToCopy > (long)buff.remaining()) {
                    bytesToCopy = buff.remaining();
                }
                src = this.readBuffer.duplicate();
                src.position((int)positionInBuffer);
                src.limit((int)(positionInBuffer + bytesToCopy));
                buff.put(src);
                pos += bytesToCopy;
                continue;
            }
            this.readBufferStartPosition = pos;
            this.readBuffer.clear();
            if (this.readBufferStartPosition + (long)this.readBuffer.capacity() >= this.writeBufferStartPosition) {
                this.readBufferStartPosition = this.writeBufferStartPosition - (long)this.readBuffer.capacity();
                if (this.readBufferStartPosition < 0L) {
                    this.readBuffer.put(LedgerEntryPage.zeroPage, 0, (int)(-this.readBufferStartPosition));
                }
            }
            while (this.readBuffer.remaining() > 0) {
                if (this.bc.read(this.readBuffer, this.readBufferStartPosition + (long)this.readBuffer.position()) > 0) continue;
                throw new IOException("Short read");
            }
            this.readBuffer.put(LedgerEntryPage.zeroPage, 0, this.readBuffer.remaining());
            this.readBuffer.clear();
        }
        return (int)(pos - prevPos);
    }
}

