/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import bk-shade.com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.FileInfo;
import org.apache.bookkeeper.bookie.LedgerCache;
import org.apache.bookkeeper.bookie.LedgerCacheBean;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerEntryPage;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.util.SnapshotMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerCacheImpl
implements LedgerCache {
    private static final Logger LOG = LoggerFactory.getLogger(LedgerCacheImpl.class);
    private static final String IDX = ".idx";
    static final String RLOC = ".rloc";
    private LedgerDirsManager ledgerDirsManager;
    private final AtomicBoolean shouldRelocateIndexFile = new AtomicBoolean(false);
    LinkedList<Long> cleanLedgers = new LinkedList();
    LinkedList<Long> dirtyLedgers = new LinkedList();
    HashMap<Long, FileInfo> fileInfoCache = new HashMap();
    LinkedList<Long> openLedgers = new LinkedList();
    final SnapshotMap<Long, Boolean> activeLedgers;
    final int openFileLimit;
    final int pageSize;
    final int pageLimit;
    final int entriesPerPage;
    private int pageCount = 0;
    HashMap<Long, HashMap<Long, LedgerEntryPage>> pages = new HashMap();

    public LedgerCacheImpl(ServerConfiguration conf, SnapshotMap<Long, Boolean> activeLedgers, LedgerDirsManager ledgerDirsManager) throws IOException {
        this.ledgerDirsManager = ledgerDirsManager;
        this.openFileLimit = conf.getOpenFileLimit();
        this.pageSize = conf.getPageSize();
        this.entriesPerPage = this.pageSize / 8;
        this.pageLimit = conf.getPageLimit() <= 0 ? (int)(Runtime.getRuntime().maxMemory() / 3L / (long)this.pageSize) : conf.getPageLimit();
        LOG.info("maxMemory = " + Runtime.getRuntime().maxMemory());
        LOG.info("openFileLimit is " + this.openFileLimit + ", pageSize is " + this.pageSize + ", pageLimit is " + this.pageLimit);
        this.activeLedgers = activeLedgers;
        this.getActiveLedgers();
        ledgerDirsManager.addLedgerDirsListener(this.getLedgerDirsListener());
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getEntriesPerPage() {
        return this.entriesPerPage;
    }

    public int getPageLimit() {
        return this.pageLimit;
    }

    public int getNumUsedPages() {
        return this.pageCount;
    }

    private void putIntoTable(HashMap<Long, HashMap<Long, LedgerEntryPage>> table, LedgerEntryPage lep) {
        HashMap<Long, LedgerEntryPage> map = table.get(lep.getLedger());
        if (map == null) {
            map = new HashMap();
            table.put(lep.getLedger(), map);
        }
        map.put(lep.getFirstEntry(), lep);
    }

    private static LedgerEntryPage getFromTable(HashMap<Long, HashMap<Long, LedgerEntryPage>> table, Long ledger, Long firstEntry) {
        HashMap<Long, LedgerEntryPage> map = table.get(ledger);
        if (map != null) {
            return map.get(firstEntry);
        }
        return null;
    }

    protected synchronized LedgerEntryPage getLedgerEntryPage(Long ledger, Long firstEntry, boolean onlyDirty) {
        LedgerEntryPage lep = LedgerCacheImpl.getFromTable(this.pages, ledger, firstEntry);
        if (lep == null) {
            return null;
        }
        lep.usePage();
        if (onlyDirty && lep.isClean()) {
            return null;
        }
        return lep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LedgerEntryPage grabLedgerEntryPage(long ledger, long pageEntry) throws IOException {
        LedgerEntryPage lep = this.grabCleanPage(ledger, pageEntry);
        try {
            this.updatePage(lep);
            LedgerCacheImpl ledgerCacheImpl = this;
            synchronized (ledgerCacheImpl) {
                this.putIntoTable(this.pages, lep);
            }
        }
        catch (IOException ie) {
            lep.releasePage();
            LedgerCacheImpl ledgerCacheImpl = this;
            synchronized (ledgerCacheImpl) {
                --this.pageCount;
            }
            throw ie;
        }
        return lep;
    }

    @Override
    public void putEntryOffset(long ledger, long entry, long offset) throws IOException {
        int offsetInPage = (int)(entry % (long)this.entriesPerPage);
        long pageEntry = entry - (long)offsetInPage;
        LedgerEntryPage lep = this.getLedgerEntryPage(ledger, pageEntry, false);
        if (lep == null) {
            lep = this.grabLedgerEntryPage(ledger, pageEntry);
        }
        if (lep != null) {
            lep.setOffset(offset, offsetInPage * 8);
            lep.releasePage();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getEntryOffset(long ledger, long entry) throws IOException {
        int offsetInPage = (int)(entry % (long)this.entriesPerPage);
        long pageEntry = entry - (long)offsetInPage;
        LedgerEntryPage lep = this.getLedgerEntryPage(ledger, pageEntry, false);
        try {
            if (lep == null) {
                lep = this.grabLedgerEntryPage(ledger, pageEntry);
            }
            long l = lep.getOffset(offsetInPage * 8);
            return l;
        }
        finally {
            if (lep != null) {
                lep.releasePage();
            }
        }
    }

    @VisibleForTesting
    public static final String getLedgerName(long ledgerId) {
        int parent = (int)(ledgerId & 0xFFL);
        int grandParent = (int)((ledgerId & 0xFF00L) >> 8);
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(grandParent));
        sb.append('/');
        sb.append(Integer.toHexString(parent));
        sb.append('/');
        sb.append(Long.toHexString(ledgerId));
        sb.append(IDX);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileInfo getFileInfo(Long ledger, byte[] masterKey) throws IOException {
        HashMap<Long, FileInfo> hashMap = this.fileInfoCache;
        synchronized (hashMap) {
            FileInfo fi = this.fileInfoCache.get(ledger);
            if (fi == null) {
                File lf = this.findIndexFile(ledger);
                if (lf == null) {
                    if (masterKey == null) {
                        throw new Bookie.NoLedgerException(ledger);
                    }
                    lf = this.getNewLedgerIndexFile(ledger, null);
                    LOG.debug("New ledger index file created for ledgerId: {}", (Object)ledger);
                    this.activeLedgers.put(ledger, true);
                }
                this.evictFileInfoIfNecessary();
                fi = new FileInfo(lf, masterKey);
                this.fileInfoCache.put(ledger, fi);
                this.openLedgers.add(ledger);
            }
            if (fi != null) {
                fi.use();
            }
            return fi;
        }
    }

    private File getNewLedgerIndexFile(Long ledger, File excludedDir) throws LedgerDirsManager.NoWritableLedgerDirException {
        File dir = this.ledgerDirsManager.pickRandomWritableDir(excludedDir);
        String ledgerName = LedgerCacheImpl.getLedgerName(ledger);
        return new File(dir, ledgerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePage(LedgerEntryPage lep) throws IOException {
        if (!lep.isClean()) {
            throw new IOException("Trying to update a dirty page");
        }
        FileInfo fi = null;
        try {
            fi = this.getFileInfo(lep.getLedger(), null);
            long pos = lep.getFirstEntry() * 8L;
            if (pos >= fi.size()) {
                lep.zeroPage();
            } else {
                lep.readPage(fi);
            }
        }
        finally {
            if (fi != null) {
                fi.release();
            }
        }
    }

    private LedgerDirsManager.LedgerDirsListener getLedgerDirsListener() {
        return new LedgerDirsManager.LedgerDirsListener(){

            @Override
            public void diskFull(File disk) {
                LedgerCacheImpl.this.shouldRelocateIndexFile.set(true);
            }

            @Override
            public void diskFailed(File disk) {
            }

            @Override
            public void allDisksFull() {
            }

            @Override
            public void fatalError() {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushLedger(boolean doAll) throws IOException {
        LinkedList<Long> linkedList = this.dirtyLedgers;
        synchronized (linkedList) {
            if (this.dirtyLedgers.isEmpty()) {
                LedgerCacheImpl ledgerCacheImpl = this;
                synchronized (ledgerCacheImpl) {
                    for (Long l : this.pages.keySet()) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Adding {} to dirty pages", (Object)Long.toHexString(l));
                        }
                        this.dirtyLedgers.add(l);
                    }
                }
            }
            if (this.dirtyLedgers.isEmpty()) {
                return;
            }
            if (this.shouldRelocateIndexFile.get()) {
                for (Long l : this.dirtyLedgers) {
                    FileInfo fi = null;
                    try {
                        fi = this.getFileInfo(l, null);
                        File currentDir = this.getLedgerDirForLedger(fi);
                        if (!this.ledgerDirsManager.isDirFull(currentDir)) continue;
                        this.moveLedgerIndexFile(l, fi);
                    }
                    finally {
                        if (null == fi) continue;
                        fi.release();
                    }
                }
                this.shouldRelocateIndexFile.set(false);
            }
            while (!this.dirtyLedgers.isEmpty()) {
                Long l = this.dirtyLedgers.removeFirst();
                this.flushLedger(l);
                if (!doAll) break;
                try {
                    this.dirtyLedgers.wait(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private File getLedgerDirForLedger(FileInfo fi) {
        return fi.getLf().getParentFile().getParentFile().getParentFile();
    }

    private void moveLedgerIndexFile(Long l, FileInfo fi) throws LedgerDirsManager.NoWritableLedgerDirException, IOException {
        File newLedgerIndexFile = this.getNewLedgerIndexFile(l, this.getLedgerDirForLedger(fi));
        fi.moveToNewLocation(newLedgerIndexFile, fi.getSizeSinceLastwrite());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushLedger(long l) throws IOException {
        FileInfo fi = null;
        try {
            fi = this.getFileInfo(l, null);
            this.flushLedger(l, fi);
        }
        catch (Bookie.NoLedgerException nle) {
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushLedger(long l, FileInfo fi) throws IOException {
        LinkedList<Long> firstEntryList;
        LedgerCacheImpl ledgerCacheImpl = this;
        synchronized (ledgerCacheImpl) {
            HashMap<Long, LedgerEntryPage> pageMap = this.pages.get(l);
            if (pageMap == null || pageMap.isEmpty()) {
                fi.flushHeader();
                return;
            }
            firstEntryList = new LinkedList<Long>();
            for (Map.Entry<Long, LedgerEntryPage> entry : pageMap.entrySet()) {
                LedgerEntryPage lep = entry.getValue();
                if (lep.isClean()) {
                    LOG.trace("Page is clean {}", (Object)lep);
                    continue;
                }
                firstEntryList.add(lep.getFirstEntry());
            }
        }
        if (firstEntryList.size() == 0) {
            LOG.debug("Nothing to flush for ledger {}.", (Object)l);
            return;
        }
        ArrayList<LedgerEntryPage> entries = new ArrayList<LedgerEntryPage>(firstEntryList.size());
        try {
            for (Long firstEntry : firstEntryList) {
                LedgerEntryPage lep = this.getLedgerEntryPage(l, firstEntry, true);
                if (lep == null) continue;
                entries.add(lep);
            }
            Collections.sort(entries, new Comparator<LedgerEntryPage>(){

                @Override
                public int compare(LedgerEntryPage o1, LedgerEntryPage o2) {
                    return (int)(o1.getFirstEntry() - o2.getFirstEntry());
                }
            });
            ArrayList<Integer> versions = new ArrayList<Integer>(entries.size());
            fi.flushHeader();
            int start = 0;
            long lastOffset = -1L;
            for (int i = 0; i < entries.size(); ++i) {
                versions.add(i, ((LedgerEntryPage)entries.get(i)).getVersion());
                if (lastOffset != -1L && ((LedgerEntryPage)entries.get(i)).getFirstEntry() - lastOffset != (long)this.entriesPerPage) {
                    int count = i - start;
                    if (count == 0) {
                        LOG.warn("Count cannot possibly be zero!");
                    }
                    this.writeBuffers(l, entries, fi, start, count);
                    start = i;
                }
                lastOffset = ((LedgerEntryPage)entries.get(i)).getFirstEntry();
            }
            if (entries.size() - start == 0 && entries.size() != 0) {
                LOG.warn("Nothing to write, but there were entries!");
            }
            this.writeBuffers(l, entries, fi, start, entries.size() - start);
            LedgerCacheImpl ledgerCacheImpl2 = this;
            synchronized (ledgerCacheImpl2) {
                for (int i = 0; i < entries.size(); ++i) {
                    LedgerEntryPage lep = (LedgerEntryPage)entries.get(i);
                    lep.setClean((Integer)versions.get(i));
                }
            }
        }
        finally {
            for (LedgerEntryPage lep : entries) {
                lep.releasePage();
            }
        }
    }

    private void writeBuffers(Long ledger, List<LedgerEntryPage> entries, FileInfo fi, int start, int count) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Writing {} buffers of {}", (Object)count, (Object)Long.toHexString(ledger));
        }
        if (count == 0) {
            return;
        }
        ByteBuffer[] buffs = new ByteBuffer[count];
        for (int j = 0; j < count; ++j) {
            buffs[j] = entries.get(start + j).getPageToWrite();
            if (entries.get(start + j).getLedger() == ledger.longValue()) continue;
            throw new IOException("Writing to " + ledger + " but page belongs to " + entries.get(start + j).getLedger());
        }
        long totalWritten = 0L;
        while (buffs[buffs.length - 1].remaining() > 0) {
            long rc = fi.write(buffs, entries.get(start + 0).getFirstEntry() * 8L);
            if (rc <= 0L) {
                throw new IOException("Short write to ledger " + ledger + " rc = " + rc);
            }
            totalWritten += rc;
        }
        if (totalWritten != (long)count * (long)this.pageSize) {
            throw new IOException("Short write to ledger " + ledger + " wrote " + totalWritten + " expected " + count * this.pageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private LedgerEntryPage grabCleanPage(long ledger, long entry) throws IOException {
        LedgerEntryPage lep;
        Iterator it;
        Map map;
        if (entry % (long)this.entriesPerPage != 0L) {
            throw new IllegalArgumentException(entry + " is not a multiple of " + this.entriesPerPage);
        }
        block9: while (true) {
            LedgerCacheImpl ledgerCacheImpl;
            Object object = this;
            // MONITORENTER : object
            if (this.pageCount < this.pageLimit) {
                LedgerEntryPage lep2 = new LedgerEntryPage(this.pageSize, this.entriesPerPage);
                lep2.setLedger(ledger);
                lep2.setFirstEntry(entry);
                lep2.usePage();
                ++this.pageCount;
                // MONITOREXIT : object
                return lep2;
            }
            // MONITOREXIT : object
            object = this.cleanLedgers;
            // MONITORENTER : object
            if (this.cleanLedgers.isEmpty()) {
                this.flushLedger(false);
                ledgerCacheImpl = this;
                // MONITORENTER : ledgerCacheImpl
                for (Long l : this.pages.keySet()) {
                    this.cleanLedgers.add(l);
                }
                // MONITOREXIT : ledgerCacheImpl
            }
            ledgerCacheImpl = this;
            // MONITORENTER : ledgerCacheImpl
            if (this.cleanLedgers.isEmpty()) {
                // MONITOREXIT : ledgerCacheImpl
                // MONITOREXIT : object
                continue;
            }
            Long cleanLedger = this.cleanLedgers.getFirst();
            map = this.pages.get(cleanLedger);
            while (map == null || map.isEmpty()) {
                this.cleanLedgers.removeFirst();
                if (this.cleanLedgers.isEmpty()) {
                    // MONITOREXIT : ledgerCacheImpl
                    // MONITOREXIT : object
                    continue block9;
                }
                cleanLedger = this.cleanLedgers.getFirst();
                map = this.pages.get(cleanLedger);
            }
            it = map.entrySet().iterator();
            lep = (LedgerEntryPage)it.next().getValue();
            while (lep.inUse() || !lep.isClean()) {
                if (!it.hasNext()) {
                    this.cleanLedgers.removeFirst();
                    // MONITOREXIT : ledgerCacheImpl
                    // MONITOREXIT : object
                    continue block9;
                }
                lep = (LedgerEntryPage)it.next().getValue();
            }
            break;
        }
        it.remove();
        if (map.isEmpty()) {
            this.pages.remove(lep.getLedger());
        }
        lep.usePage();
        lep.zeroPage();
        lep.setLedger(ledger);
        lep.setFirstEntry(entry);
        // MONITOREXIT : ledgerCacheImpl
        // MONITOREXIT : object
        return lep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastEntry(long ledgerId) throws IOException {
        long lastEntry;
        block14: {
            lastEntry = 0L;
            LedgerCacheImpl ledgerCacheImpl = this;
            synchronized (ledgerCacheImpl) {
                Map map = this.pages.get(ledgerId);
                if (map != null) {
                    for (LedgerEntryPage lep : map.values()) {
                        if (lep.getFirstEntry() + (long)this.entriesPerPage < lastEntry) continue;
                        lep.usePage();
                        long highest = lep.getLastEntry();
                        if (highest > lastEntry) {
                            lastEntry = highest;
                        }
                        lep.releasePage();
                    }
                }
            }
            FileInfo fi = null;
            try {
                fi = this.getFileInfo(ledgerId, null);
                long size = fi.size();
                if (0L != size % 8L) {
                    LOG.warn("Index file of ledger {} is not aligned with index entry size.", (Object)ledgerId);
                    size -= size % 8L;
                }
                if (size <= lastEntry * 8L) break block14;
                ByteBuffer bb = ByteBuffer.allocate(this.getPageSize());
                long position = size - (long)this.getPageSize();
                if (position < 0L) {
                    position = 0L;
                }
                fi.read(bb, position);
                bb.flip();
                long startingEntryId = position / 8L;
                for (int i = this.getEntriesPerPage() - 1; i >= 0; --i) {
                    if (bb.getLong(i * 8) == 0L) continue;
                    if (lastEntry < startingEntryId + (long)i) {
                        lastEntry = startingEntryId + (long)i;
                    }
                    break;
                }
            }
            finally {
                if (fi != null) {
                    fi.release();
                }
            }
        }
        return lastEntry;
    }

    private void getActiveLedgers() throws IOException {
        for (File ledgerDirectory : this.ledgerDirsManager.getAllLedgerDirs()) {
            for (File grandParent : ledgerDirectory.listFiles()) {
                if (!grandParent.isDirectory()) continue;
                for (File parent : grandParent.listFiles()) {
                    if (!parent.isDirectory()) continue;
                    for (File index : parent.listFiles()) {
                        if (!index.isFile() || !index.getName().endsWith(IDX) && !index.getName().endsWith(RLOC)) continue;
                        String ledgerIdInHex = index.getName().replace(RLOC, "").replace(IDX, "");
                        if (index.getName().endsWith(RLOC)) {
                            if (this.findIndexFile(Long.parseLong(ledgerIdInHex)) != null) {
                                if (index.delete()) continue;
                                LOG.warn("Deleting the rloc file " + index + " failed");
                                continue;
                            }
                            File dest = new File(index.getParentFile(), ledgerIdInHex + IDX);
                            if (!index.renameTo(dest)) {
                                throw new IOException("Renaming rloc file " + index + " to index file has failed");
                            }
                        }
                        this.activeLedgers.put(Long.parseLong(ledgerIdInHex, 16), true);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteLedger(long ledgerId) throws IOException {
        LOG.debug("Deleting ledgerId: {}", (Object)ledgerId);
        LedgerCacheImpl ledgerCacheImpl = this;
        synchronized (ledgerCacheImpl) {
            Map lpages = this.pages.remove(ledgerId);
            if (null != lpages) {
                this.pageCount -= lpages.size();
                if (this.pageCount < 0) {
                    LOG.error("Page count of ledger cache has been decremented to be less than zero.");
                }
            }
        }
        FileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            fi.close(false);
            fi.delete();
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
        this.activeLedgers.remove(ledgerId);
        Cloneable cloneable = this.fileInfoCache;
        synchronized (cloneable) {
            this.fileInfoCache.remove(ledgerId);
        }
        cloneable = this.cleanLedgers;
        synchronized (cloneable) {
            this.cleanLedgers.remove(ledgerId);
        }
        cloneable = this.dirtyLedgers;
        synchronized (cloneable) {
            this.dirtyLedgers.remove(ledgerId);
        }
        cloneable = this.openLedgers;
        synchronized (cloneable) {
            this.openLedgers.remove(ledgerId);
        }
    }

    private File findIndexFile(long ledgerId) throws IOException {
        String ledgerName = LedgerCacheImpl.getLedgerName(ledgerId);
        for (File d : this.ledgerDirsManager.getAllLedgerDirs()) {
            File lf = new File(d, ledgerName);
            if (!lf.exists()) continue;
            return lf;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readMasterKey(long ledgerId) throws IOException, BookieException {
        HashMap<Long, FileInfo> hashMap = this.fileInfoCache;
        synchronized (hashMap) {
            FileInfo fi = this.fileInfoCache.get(ledgerId);
            if (fi == null) {
                File lf = this.findIndexFile(ledgerId);
                if (lf == null) {
                    throw new Bookie.NoLedgerException(ledgerId);
                }
                this.evictFileInfoIfNecessary();
                fi = new FileInfo(lf, null);
                byte[] key = fi.getMasterKey();
                this.fileInfoCache.put(ledgerId, fi);
                this.openLedgers.add(ledgerId);
                return key;
            }
            return fi.getMasterKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictFileInfoIfNecessary() throws IOException {
        HashMap<Long, FileInfo> hashMap = this.fileInfoCache;
        synchronized (hashMap) {
            if (this.openLedgers.size() > this.openFileLimit) {
                long ledgerToRemove = this.openLedgers.removeFirst();
                LOG.debug("Ledger {} is evicted from file info cache.", (Object)ledgerToRemove);
                FileInfo fi = this.fileInfoCache.remove(ledgerToRemove);
                if (fi != null) {
                    fi.close(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setFenced(long ledgerId) throws IOException {
        FileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            if (null != fi) {
                boolean bl = fi.setFenced();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFenced(long ledgerId) throws IOException {
        FileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            if (null != fi) {
                boolean bl = fi.isFenced();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMasterKey(long ledgerId, byte[] masterKey) throws IOException {
        FileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, masterKey);
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ledgerExists(long ledgerId) throws IOException {
        HashMap<Long, FileInfo> hashMap = this.fileInfoCache;
        synchronized (hashMap) {
            File lf;
            FileInfo fi = this.fileInfoCache.get(ledgerId);
            if (fi == null && (lf = this.findIndexFile(ledgerId)) == null) {
                return false;
            }
        }
        return true;
    }

    @Override
    public LedgerCacheBean getJMXBean() {
        return new LedgerCacheBean(){

            public String getName() {
                return "LedgerCache";
            }

            public boolean isHidden() {
                return false;
            }

            @Override
            public int getPageCount() {
                return LedgerCacheImpl.this.getNumUsedPages();
            }

            @Override
            public int getPageSize() {
                return LedgerCacheImpl.this.getPageSize();
            }

            @Override
            public int getOpenFileLimit() {
                return LedgerCacheImpl.this.openFileLimit;
            }

            @Override
            public int getPageLimit() {
                return LedgerCacheImpl.this.getPageLimit();
            }

            @Override
            public int getNumCleanLedgers() {
                return LedgerCacheImpl.this.cleanLedgers.size();
            }

            @Override
            public int getNumDirtyLedgers() {
                return LedgerCacheImpl.this.dirtyLedgers.size();
            }

            @Override
            public int getNumOpenLedgers() {
                return LedgerCacheImpl.this.openLedgers.size();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        HashMap<Long, FileInfo> hashMap = this.fileInfoCache;
        synchronized (hashMap) {
            for (Map.Entry<Long, FileInfo> fileInfo : this.fileInfoCache.entrySet()) {
                FileInfo value = fileInfo.getValue();
                if (value == null) continue;
                value.close(true);
            }
            this.fileInfoCache.clear();
        }
    }
}

