/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.LedgerDescriptor;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerDescriptorImpl
extends LedgerDescriptor {
    static final Logger LOG = LoggerFactory.getLogger(LedgerDescriptor.class);
    final LedgerStorage ledgerStorage;
    private long ledgerId;
    final byte[] masterKey;

    LedgerDescriptorImpl(byte[] masterKey, long ledgerId, LedgerStorage ledgerStorage) {
        this.masterKey = masterKey;
        this.ledgerId = ledgerId;
        this.ledgerStorage = ledgerStorage;
    }

    @Override
    void checkAccess(byte[] masterKey) throws BookieException, IOException {
        if (!Arrays.equals(this.masterKey, masterKey)) {
            throw BookieException.create(-1);
        }
    }

    @Override
    public long getLedgerId() {
        return this.ledgerId;
    }

    @Override
    boolean setFenced() throws IOException {
        return this.ledgerStorage.setFenced(this.ledgerId);
    }

    @Override
    boolean isFenced() throws IOException {
        return this.ledgerStorage.isFenced(this.ledgerId);
    }

    @Override
    long addEntry(ByteBuffer entry) throws IOException {
        long ledgerId = entry.getLong();
        if (ledgerId != this.ledgerId) {
            throw new IOException("Entry for ledger " + ledgerId + " was sent to " + this.ledgerId);
        }
        entry.rewind();
        return this.ledgerStorage.addEntry(entry);
    }

    @Override
    ByteBuffer readEntry(long entryId) throws IOException {
        return this.ledgerStorage.getEntry(this.ledgerId, entryId);
    }
}

