/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookieWatcher;
import org.apache.bookkeeper.client.LedgerCreateOp;
import org.apache.bookkeeper.client.LedgerDeleteOp;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.client.LedgerOpenOp;
import org.apache.bookkeeper.client.SyncCounter;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.util.OrderedSafeExecutor;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.bookkeeper.zookeeper.ZooKeeperWatcherBase;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeper {
    static final Logger LOG = LoggerFactory.getLogger(BookKeeper.class);
    final ZooKeeper zk;
    final CountDownLatch connectLatch = new CountDownLatch(1);
    static final int zkConnectTimeoutMs = 5000;
    final ClientSocketChannelFactory channelFactory;
    boolean ownChannelFactory = false;
    boolean ownZKHandle = false;
    final BookieClient bookieClient;
    final BookieWatcher bookieWatcher;
    final OrderedSafeExecutor mainWorkerPool;
    final ScheduledExecutorService scheduler;
    final LedgerManagerFactory ledgerManagerFactory;
    final LedgerManager ledgerManager;
    final ClientConfiguration conf;

    public BookKeeper(String servers) throws IOException, InterruptedException, KeeperException {
        this(new ClientConfiguration().setZkServers(servers));
    }

    public BookKeeper(ClientConfiguration conf) throws IOException, InterruptedException, KeeperException {
        this.conf = conf;
        ZooKeeperWatcherBase w = new ZooKeeperWatcherBase(conf.getZkTimeout());
        this.zk = ZkUtils.createConnectedZookeeperClient(conf.getZkServers(), w);
        this.channelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.mainWorkerPool = new OrderedSafeExecutor(conf.getNumWorkerThreads());
        this.bookieClient = new BookieClient(conf, this.channelFactory, this.mainWorkerPool);
        this.bookieWatcher = new BookieWatcher(conf, this.scheduler, this);
        this.bookieWatcher.readBookiesBlocking();
        this.ledgerManagerFactory = LedgerManagerFactory.newLedgerManagerFactory(conf, this.zk);
        this.ledgerManager = this.ledgerManagerFactory.newLedgerManager();
        this.ownChannelFactory = true;
        this.ownZKHandle = true;
    }

    public BookKeeper(ClientConfiguration conf, ZooKeeper zk) throws IOException, InterruptedException, KeeperException {
        this(conf, zk, (ClientSocketChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
        this.ownChannelFactory = true;
    }

    public BookKeeper(ClientConfiguration conf, ZooKeeper zk, ClientSocketChannelFactory channelFactory) throws IOException, InterruptedException, KeeperException {
        if (zk == null || channelFactory == null) {
            throw new NullPointerException();
        }
        if (!zk.getState().isConnected()) {
            LOG.error("Unconnected zookeeper handle passed to bookkeeper");
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.CONNECTIONLOSS);
        }
        this.conf = conf;
        this.zk = zk;
        this.channelFactory = channelFactory;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.mainWorkerPool = new OrderedSafeExecutor(conf.getNumWorkerThreads());
        this.bookieClient = new BookieClient(conf, channelFactory, this.mainWorkerPool);
        this.bookieWatcher = new BookieWatcher(conf, this.scheduler, this);
        this.bookieWatcher.readBookiesBlocking();
        this.ledgerManagerFactory = LedgerManagerFactory.newLedgerManagerFactory(conf, zk);
        this.ledgerManager = this.ledgerManagerFactory.newLedgerManager();
    }

    LedgerManager getLedgerManager() {
        return this.ledgerManager;
    }

    ZooKeeper getZkHandle() {
        return this.zk;
    }

    protected ClientConfiguration getConf() {
        return this.conf;
    }

    BookieClient getBookieClient() {
        return this.bookieClient;
    }

    public void asyncCreateLedger(int ensSize, int writeQuorumSize, DigestType digestType, byte[] passwd, AsyncCallback.CreateCallback cb, Object ctx) {
        this.asyncCreateLedger(ensSize, writeQuorumSize, writeQuorumSize, digestType, passwd, cb, ctx);
    }

    public void asyncCreateLedger(int ensSize, int writeQuorumSize, int ackQuorumSize, DigestType digestType, byte[] passwd, AsyncCallback.CreateCallback cb, Object ctx) {
        if (writeQuorumSize < ackQuorumSize) {
            throw new IllegalArgumentException("Write quorum must be larger than ack quorum");
        }
        new LedgerCreateOp(this, ensSize, writeQuorumSize, ackQuorumSize, digestType, passwd, cb, ctx).initiate();
    }

    public LedgerHandle createLedger(DigestType digestType, byte[] passwd) throws BKException, InterruptedException {
        return this.createLedger(3, 2, digestType, passwd);
    }

    public LedgerHandle createLedger(int ensSize, int qSize, DigestType digestType, byte[] passwd) throws InterruptedException, BKException {
        return this.createLedger(ensSize, qSize, qSize, digestType, passwd);
    }

    public LedgerHandle createLedger(int ensSize, int writeQuorumSize, int ackQuorumSize, DigestType digestType, byte[] passwd) throws InterruptedException, BKException {
        SyncCounter counter = new SyncCounter();
        counter.inc();
        this.asyncCreateLedger(ensSize, writeQuorumSize, ackQuorumSize, digestType, passwd, new SyncCreateCallback(), counter);
        counter.block(0);
        if (counter.getrc() != 0) {
            LOG.error("Error while creating ledger : {}", (Object)counter.getrc());
            throw BKException.create(counter.getrc());
        }
        if (counter.getLh() == null) {
            LOG.error("Unexpected condition : no ledger handle returned for a success ledger creation");
            throw BKException.create(-999);
        }
        return counter.getLh();
    }

    public void asyncOpenLedger(long lId, DigestType digestType, byte[] passwd, AsyncCallback.OpenCallback cb, Object ctx) {
        new LedgerOpenOp(this, lId, digestType, passwd, cb, ctx).initiate();
    }

    public void asyncOpenLedgerNoRecovery(long lId, DigestType digestType, byte[] passwd, AsyncCallback.OpenCallback cb, Object ctx) {
        new LedgerOpenOp(this, lId, digestType, passwd, cb, ctx).initiateWithoutRecovery();
    }

    public LedgerHandle openLedger(long lId, DigestType digestType, byte[] passwd) throws BKException, InterruptedException {
        SyncCounter counter = new SyncCounter();
        counter.inc();
        this.asyncOpenLedger(lId, digestType, passwd, new SyncOpenCallback(), counter);
        counter.block(0);
        if (counter.getrc() != 0) {
            throw BKException.create(counter.getrc());
        }
        return counter.getLh();
    }

    public LedgerHandle openLedgerNoRecovery(long lId, DigestType digestType, byte[] passwd) throws BKException, InterruptedException {
        SyncCounter counter = new SyncCounter();
        counter.inc();
        this.asyncOpenLedgerNoRecovery(lId, digestType, passwd, new SyncOpenCallback(), counter);
        counter.block(0);
        if (counter.getrc() != 0) {
            throw BKException.create(counter.getrc());
        }
        return counter.getLh();
    }

    public void asyncDeleteLedger(long lId, AsyncCallback.DeleteCallback cb, Object ctx) {
        new LedgerDeleteOp(this, lId, cb, ctx).initiate();
    }

    public void deleteLedger(long lId) throws InterruptedException, BKException {
        SyncCounter counter = new SyncCounter();
        counter.inc();
        this.asyncDeleteLedger(lId, new SyncDeleteCallback(), counter);
        counter.block(0);
        if (counter.getrc() != 0) {
            LOG.error("Error deleting ledger " + lId + " : " + counter.getrc());
            throw BKException.create(counter.getrc());
        }
    }

    public void asyncIsClosed(long lId, final AsyncCallback.IsClosedCallback cb, final Object ctx) {
        this.ledgerManager.readLedgerMetadata(lId, new BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata>(){

            @Override
            public void operationComplete(int rc, LedgerMetadata lm) {
                if (rc == 0) {
                    cb.isClosedComplete(rc, lm.isClosed(), ctx);
                } else {
                    cb.isClosedComplete(rc, false, ctx);
                }
            }
        });
    }

    public boolean isClosed(long lId) throws BKException, InterruptedException {
        final class Result {
            int rc;
            boolean isClosed;
            final CountDownLatch notifier = new CountDownLatch(1);

            Result() {
            }
        }
        final Result result = new Result();
        AsyncCallback.IsClosedCallback cb = new AsyncCallback.IsClosedCallback(){
            {
            }

            @Override
            public void isClosedComplete(int rc, boolean isClosed, Object ctx) {
                result.isClosed = isClosed;
                result.rc = rc;
                result.notifier.countDown();
            }
        };
        this.asyncIsClosed(lId, cb, null);
        result.notifier.await();
        if (result.rc != 0) {
            throw BKException.create(result.rc);
        }
        return result.isClosed;
    }

    public void close() throws InterruptedException, BKException {
        this.scheduler.shutdown();
        if (!this.scheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
            LOG.warn("The scheduler did not shutdown cleanly");
        }
        this.mainWorkerPool.shutdown();
        if (!this.mainWorkerPool.awaitTermination(10L, TimeUnit.SECONDS)) {
            LOG.warn("The mainWorkerPool did not shutdown cleanly");
        }
        this.bookieClient.close();
        try {
            this.ledgerManager.close();
            this.ledgerManagerFactory.uninitialize();
        }
        catch (IOException ie) {
            LOG.error("Failed to close ledger manager : ", (Throwable)ie);
        }
        if (this.ownChannelFactory) {
            this.channelFactory.releaseExternalResources();
        }
        if (this.ownZKHandle) {
            this.zk.close();
        }
    }

    private static class SyncDeleteCallback
    implements AsyncCallback.DeleteCallback {
        private SyncDeleteCallback() {
        }

        @Override
        public void deleteComplete(int rc, Object ctx) {
            SyncCounter counter = (SyncCounter)ctx;
            counter.setrc(rc);
            counter.dec();
        }
    }

    static class SyncOpenCallback
    implements AsyncCallback.OpenCallback {
        SyncOpenCallback() {
        }

        @Override
        public void openComplete(int rc, LedgerHandle lh, Object ctx) {
            SyncCounter counter = (SyncCounter)ctx;
            counter.setLh(lh);
            LOG.debug("Open complete: {}", (Object)rc);
            counter.setrc(rc);
            counter.dec();
        }
    }

    private static class SyncCreateCallback
    implements AsyncCallback.CreateCallback {
        private SyncCreateCallback() {
        }

        @Override
        public void createComplete(int rc, LedgerHandle lh, Object ctx) {
            SyncCounter counter = (SyncCounter)ctx;
            counter.setLh(lh);
            counter.setrc(rc);
            counter.dec();
        }
    }

    public static enum DigestType {
        MAC,
        CRC32;

    }

    static interface ZKConnectCallback {
        public void connected();

        public void connectionFailed(int var1);
    }
}

