/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.CRC32DigestManager;
import org.apache.bookkeeper.client.MacDigestManager;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DigestManager {
    static final Logger logger = LoggerFactory.getLogger(DigestManager.class);
    static final int METADATA_LENGTH = 32;
    long ledgerId;
    final int macCodeLength;

    abstract int getMacCodeLength();

    void update(byte[] data) {
        this.update(data, 0, data.length);
    }

    abstract void update(byte[] var1, int var2, int var3);

    abstract byte[] getValueAndReset();

    public DigestManager(long ledgerId) {
        this.ledgerId = ledgerId;
        this.macCodeLength = this.getMacCodeLength();
    }

    static DigestManager instantiate(long ledgerId, byte[] passwd, BookKeeper.DigestType digestType) throws GeneralSecurityException {
        switch (digestType) {
            case MAC: {
                return new MacDigestManager(ledgerId, passwd);
            }
            case CRC32: {
                return new CRC32DigestManager(ledgerId);
            }
        }
        throw new GeneralSecurityException("Unknown checksum type: " + (Object)((Object)digestType));
    }

    public ChannelBuffer computeDigestAndPackageForSending(long entryId, long lastAddConfirmed, long length, byte[] data, int doffset, int dlength) {
        byte[] bufferArray = new byte[32 + this.macCodeLength];
        ByteBuffer buffer = ByteBuffer.wrap(bufferArray);
        buffer.putLong(this.ledgerId);
        buffer.putLong(entryId);
        buffer.putLong(lastAddConfirmed);
        buffer.putLong(length);
        buffer.flip();
        this.update(buffer.array(), 0, 32);
        this.update(data, doffset, dlength);
        byte[] digest = this.getValueAndReset();
        buffer.limit(buffer.capacity());
        buffer.position(32);
        buffer.put(digest);
        buffer.flip();
        return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{ChannelBuffers.wrappedBuffer((ByteBuffer)buffer), ChannelBuffers.wrappedBuffer((byte[])data, (int)doffset, (int)dlength)});
    }

    private void verifyDigest(ChannelBuffer dataReceived) throws BKException.BKDigestMatchException {
        this.verifyDigest(-1L, dataReceived, true);
    }

    private void verifyDigest(long entryId, ChannelBuffer dataReceived) throws BKException.BKDigestMatchException {
        this.verifyDigest(entryId, dataReceived, false);
    }

    private void verifyDigest(long entryId, ChannelBuffer dataReceived, boolean skipEntryIdCheck) throws BKException.BKDigestMatchException {
        ByteBuffer dataReceivedBuffer = dataReceived.toByteBuffer();
        if (32 + this.macCodeLength > dataReceived.readableBytes()) {
            logger.error("Data received is smaller than the minimum for this digest type.  Either the packet it corrupt, or the wrong digest is configured.  Digest type: {}, Packet Length: {}", (Object)this.getClass().getName(), (Object)dataReceived.readableBytes());
            throw new BKException.BKDigestMatchException();
        }
        this.update(dataReceivedBuffer.array(), dataReceivedBuffer.position(), 32);
        int offset = 32 + this.macCodeLength;
        this.update(dataReceivedBuffer.array(), dataReceivedBuffer.position() + offset, dataReceived.readableBytes() - offset);
        byte[] digest = this.getValueAndReset();
        for (int i = 0; i < digest.length; ++i) {
            if (digest[i] == dataReceived.getByte(32 + i)) continue;
            logger.error("Mac mismatch for ledger-id: " + this.ledgerId + ", entry-id: " + entryId);
            throw new BKException.BKDigestMatchException();
        }
        long actualLedgerId = dataReceived.readLong();
        long actualEntryId = dataReceived.readLong();
        if (actualLedgerId != this.ledgerId) {
            logger.error("Ledger-id mismatch in authenticated message, expected: " + this.ledgerId + " , actual: " + actualLedgerId);
            throw new BKException.BKDigestMatchException();
        }
        if (!skipEntryIdCheck && actualEntryId != entryId) {
            logger.error("Entry-id mismatch in authenticated message, expected: " + entryId + " , actual: " + actualEntryId);
            throw new BKException.BKDigestMatchException();
        }
    }

    ChannelBufferInputStream verifyDigestAndReturnData(long entryId, ChannelBuffer dataReceived) throws BKException.BKDigestMatchException {
        this.verifyDigest(entryId, dataReceived);
        dataReceived.readerIndex(32 + this.macCodeLength);
        return new ChannelBufferInputStream(dataReceived);
    }

    RecoveryData verifyDigestAndReturnLastConfirmed(ChannelBuffer dataReceived) throws BKException.BKDigestMatchException {
        this.verifyDigest(dataReceived);
        dataReceived.readerIndex(8);
        dataReceived.readLong();
        long lastAddConfirmed = dataReceived.readLong();
        long length = dataReceived.readLong();
        return new RecoveryData(lastAddConfirmed, length);
    }

    static class RecoveryData {
        long lastAddConfirmed;
        long length;

        public RecoveryData(long lastAddConfirmed, long length) {
            this.lastAddConfirmed = lastAddConfirmed;
            this.length = length;
        }
    }
}

