/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.client.ReadOnlyLedgerHandle;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.util.OrderedSafeExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerOpenOp
implements BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata> {
    static final Logger LOG = LoggerFactory.getLogger(LedgerOpenOp.class);
    final BookKeeper bk;
    final long ledgerId;
    final AsyncCallback.OpenCallback cb;
    final Object ctx;
    LedgerHandle lh;
    final byte[] passwd;
    final BookKeeper.DigestType digestType;
    boolean doRecovery = true;
    boolean administrativeOpen = false;

    public LedgerOpenOp(BookKeeper bk, long ledgerId, BookKeeper.DigestType digestType, byte[] passwd, AsyncCallback.OpenCallback cb, Object ctx) {
        this.bk = bk;
        this.ledgerId = ledgerId;
        this.passwd = passwd;
        this.cb = cb;
        this.ctx = ctx;
        this.digestType = digestType;
    }

    public LedgerOpenOp(BookKeeper bk, long ledgerId, AsyncCallback.OpenCallback cb, Object ctx) {
        this.bk = bk;
        this.ledgerId = ledgerId;
        this.cb = cb;
        this.ctx = ctx;
        this.passwd = bk.getConf().getBookieRecoveryPasswd();
        this.digestType = bk.getConf().getBookieRecoveryDigestType();
        this.administrativeOpen = true;
    }

    public void initiate() {
        this.bk.getLedgerManager().readLedgerMetadata(this.ledgerId, this);
    }

    public void initiateWithoutRecovery() {
        this.doRecovery = false;
        this.initiate();
    }

    @Override
    public void operationComplete(int rc, LedgerMetadata metadata) {
        BookKeeper.DigestType digestType;
        byte[] passwd;
        if (0 != rc) {
            this.cb.openComplete(rc, null, this.ctx);
            return;
        }
        if (this.administrativeOpen && metadata.hasPassword()) {
            passwd = metadata.getPassword();
            digestType = metadata.getDigestType();
        } else {
            passwd = this.passwd;
            digestType = this.digestType;
            if (metadata.hasPassword()) {
                if (!Arrays.equals(passwd, metadata.getPassword())) {
                    LOG.error("Provided passwd does not match that in metadata");
                    this.cb.openComplete(-102, null, this.ctx);
                    return;
                }
                if (digestType != metadata.getDigestType()) {
                    LOG.error("Provided digest does not match that in metadata");
                    this.cb.openComplete(-5, null, this.ctx);
                    return;
                }
            }
        }
        try {
            this.lh = new ReadOnlyLedgerHandle(this.bk, this.ledgerId, metadata, digestType, passwd, !this.doRecovery);
        }
        catch (GeneralSecurityException e) {
            LOG.error("Security exception while opening ledger: " + this.ledgerId, (Throwable)e);
            this.cb.openComplete(-4, null, this.ctx);
            return;
        }
        catch (NumberFormatException e) {
            LOG.error("Incorrectly entered parameter throttle: " + this.bk.getConf().getThrottleValue(), (Throwable)e);
            this.cb.openComplete(-14, null, this.ctx);
            return;
        }
        if (metadata.isClosed()) {
            this.cb.openComplete(0, this.lh, this.ctx);
            return;
        }
        if (this.doRecovery) {
            this.lh.recover((BookkeeperInternalCallbacks.GenericCallback<Void>)new OrderedSafeExecutor.OrderedSafeGenericCallback<Void>(this.bk.mainWorkerPool, (Object)this.ledgerId){

                @Override
                public void safeOperationComplete(int rc, Void result) {
                    if (rc == 0) {
                        LedgerOpenOp.this.cb.openComplete(0, LedgerOpenOp.this.lh, LedgerOpenOp.this.ctx);
                    } else if (rc == -102) {
                        LedgerOpenOp.this.cb.openComplete(-102, null, LedgerOpenOp.this.ctx);
                    } else {
                        LedgerOpenOp.this.cb.openComplete(-10, null, LedgerOpenOp.this.ctx);
                    }
                }
            });
        } else {
            this.lh.asyncReadLastConfirmed(new AsyncCallback.ReadLastConfirmedCallback(){

                @Override
                public void readLastConfirmedComplete(int rc, long lastConfirmed, Object ctx) {
                    if (rc != 0) {
                        LedgerOpenOp.this.cb.openComplete(-1, null, LedgerOpenOp.this.ctx);
                    } else {
                        LedgerOpenOp.this.lh.lastAddConfirmed = LedgerOpenOp.this.lh.lastAddPushed = lastConfirmed;
                        LedgerOpenOp.this.cb.openComplete(0, LedgerOpenOp.this.lh, LedgerOpenOp.this.ctx);
                    }
                }
            }, null);
        }
    }
}

