/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.conf;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.commons.lang.StringUtils;

public class ClientConfiguration
extends AbstractConfiguration {
    protected static final String ZK_TIMEOUT = "zkTimeout";
    protected static final String ZK_SERVERS = "zkServers";
    protected static final String THROTTLE = "throttle";
    protected static final String DIGEST_TYPE = "digestType";
    protected static final String PASSWD = "passwd";
    protected static final String CLIENT_TCP_NODELAY = "clientTcpNoDelay";
    protected static final String READ_TIMEOUT = "readTimeout";
    protected static final String SPECULATIVE_READ_TIMEOUT = "speculativeReadTimeout";
    protected static final String ADD_ENTRY_TIMEOUT_SEC = "addEntryTimeoutSec";
    protected static final String READ_ENTRY_TIMEOUT_SEC = "readEntryTimeoutSec";
    protected static final String TIMEOUT_TASK_INTERVAL_MILLIS = "timeoutTaskIntervalMillis";
    protected static final String NUM_WORKER_THREADS = "numWorkerThreads";

    public ClientConfiguration() {
    }

    public ClientConfiguration(AbstractConfiguration conf) {
        this.loadConf(conf);
    }

    public int getThrottleValue() {
        return this.getInt(THROTTLE, 5000);
    }

    public ClientConfiguration setThrottleValue(int throttle) {
        this.setProperty(THROTTLE, Integer.toString(throttle));
        return this;
    }

    public BookKeeper.DigestType getBookieRecoveryDigestType() {
        return BookKeeper.DigestType.valueOf(this.getString(DIGEST_TYPE, BookKeeper.DigestType.CRC32.toString()));
    }

    public ClientConfiguration setBookieRecoveryDigestType(BookKeeper.DigestType digestType) {
        this.setProperty(DIGEST_TYPE, digestType.toString());
        return this;
    }

    public byte[] getBookieRecoveryPasswd() {
        return this.getString(PASSWD, "").getBytes();
    }

    public ClientConfiguration setBookieRecoveryPasswd(byte[] passwd) {
        this.setProperty(PASSWD, new String(passwd));
        return this;
    }

    public boolean getClientTcpNoDelay() {
        return this.getBoolean(CLIENT_TCP_NODELAY, true);
    }

    public ClientConfiguration setClientTcpNoDelay(boolean noDelay) {
        this.setProperty(CLIENT_TCP_NODELAY, Boolean.toString(noDelay));
        return this;
    }

    public String getZkServers() {
        List servers = this.getList(ZK_SERVERS, null);
        if (null == servers || 0 == servers.size()) {
            return "localhost";
        }
        return StringUtils.join((Collection)servers, (String)",");
    }

    public ClientConfiguration setZkServers(String zkServers) {
        this.setProperty(ZK_SERVERS, zkServers);
        return this;
    }

    public int getZkTimeout() {
        return this.getInt(ZK_TIMEOUT, 10000);
    }

    public ClientConfiguration setZkTimeout(int zkTimeout) {
        this.setProperty(ZK_TIMEOUT, Integer.toString(zkTimeout));
        return this;
    }

    @Deprecated
    public int getReadTimeout() {
        return this.getInt(READ_TIMEOUT, 5);
    }

    @Deprecated
    public ClientConfiguration setReadTimeout(int timeout) {
        this.setProperty(READ_TIMEOUT, Integer.toString(timeout));
        return this;
    }

    public int getAddEntryTimeout() {
        return this.getInt(ADD_ENTRY_TIMEOUT_SEC, this.getReadTimeout());
    }

    public ClientConfiguration setAddEntryTimeout(int timeout) {
        this.setProperty(ADD_ENTRY_TIMEOUT_SEC, timeout);
        return this;
    }

    public int getReadEntryTimeout() {
        return this.getInt(READ_ENTRY_TIMEOUT_SEC, this.getReadTimeout());
    }

    public ClientConfiguration setReadEntryTimeout(int timeout) {
        this.setProperty(READ_ENTRY_TIMEOUT_SEC, timeout);
        return this;
    }

    public long getTimeoutTaskIntervalMillis() {
        return this.getLong(TIMEOUT_TASK_INTERVAL_MILLIS, TimeUnit.SECONDS.toMillis(Math.min(this.getAddEntryTimeout(), this.getReadEntryTimeout())));
    }

    public ClientConfiguration setTimeoutTaskIntervalMillis(long timeoutMillis) {
        this.setProperty(TIMEOUT_TASK_INTERVAL_MILLIS, Long.toString(timeoutMillis));
        return this;
    }

    public int getNumWorkerThreads() {
        return this.getInt(NUM_WORKER_THREADS, Runtime.getRuntime().availableProcessors());
    }

    public ClientConfiguration setNumWorkerThreads(int numThreads) {
        this.setProperty(NUM_WORKER_THREADS, numThreads);
        return this;
    }

    public int getSpeculativeReadTimeout() {
        return this.getInt(SPECULATIVE_READ_TIMEOUT, 2000);
    }

    public ClientConfiguration setSpeculativeReadTimeout(int timeout) {
        this.setProperty(SPECULATIVE_READ_TIMEOUT, timeout);
        return this;
    }
}

