/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import bk-shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.ZkVersion;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.bookkeeper.versioning.Version;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractZkLedgerManager
implements LedgerManager,
Watcher {
    static Logger LOG = LoggerFactory.getLogger(AbstractZkLedgerManager.class);
    static int ZK_CONNECT_BACKOFF_MS = 200;
    protected final AbstractConfiguration conf;
    protected final ZooKeeper zk;
    protected final String ledgerRootPath;
    protected final ConcurrentMap<Long, Set<BookkeeperInternalCallbacks.LedgerMetadataListener>> listeners = new ConcurrentHashMap<Long, Set<BookkeeperInternalCallbacks.LedgerMetadataListener>>();
    protected ScheduledExecutorService scheduler;

    protected AbstractZkLedgerManager(AbstractConfiguration conf, ZooKeeper zk) {
        this.conf = conf;
        this.zk = zk;
        this.ledgerRootPath = conf.getZkLedgersRootPath();
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder().setNameFormat("ZkLedgerManagerScheduler-%d");
        this.scheduler = Executors.newSingleThreadScheduledExecutor(tfb.build());
        LOG.debug("Using AbstractZkLedgerManager with root path : {}", (Object)this.ledgerRootPath);
    }

    protected abstract String getLedgerPath(long var1);

    protected abstract long getLedgerId(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(WatchedEvent event) {
        long ledgerId;
        LOG.info("Received watched event {} from zookeeper based ledger manager.", (Object)event);
        if (Watcher.Event.EventType.None == event.getType()) {
            return;
        }
        String path = event.getPath();
        if (null == path) {
            return;
        }
        try {
            ledgerId = this.getLedgerId(event.getPath());
        }
        catch (IOException ioe) {
            LOG.info("Received invalid ledger path {} : ", (Object)event.getPath(), (Object)ioe);
            return;
        }
        switch (event.getType()) {
            case NodeDeleted: {
                Set listenerSet = (Set)this.listeners.get(ledgerId);
                if (null != listenerSet) {
                    Set set = listenerSet;
                    synchronized (set) {
                        LOG.debug("Removed ledger metadata listeners on ledger {} : {}", (Object)ledgerId, (Object)listenerSet);
                        for (BookkeeperInternalCallbacks.LedgerMetadataListener l : listenerSet) {
                            this.unregisterLedgerMetadataListener(ledgerId, l);
                            l.onChanged(ledgerId, null);
                        }
                        break;
                    }
                }
                LOG.debug("No ledger metadata listeners to remove from ledger {} after it's deleted.", (Object)ledgerId);
                break;
            }
            case NodeDataChanged: {
                new ReadLedgerMetadataTask(ledgerId).run();
                break;
            }
            default: {
                LOG.debug("Received event {} on {}.", (Object)event.getType(), (Object)event.getPath());
            }
        }
    }

    @Override
    public void removeLedgerMetadata(final long ledgerId, Version version, final BookkeeperInternalCallbacks.GenericCallback<Void> cb) {
        int znodeVersion = -1;
        if (Version.NEW == version) {
            LOG.error("Request to delete ledger {} metadata with version set to the initial one", (Object)ledgerId);
            cb.operationComplete(-17, null);
            return;
        }
        if (Version.ANY != version) {
            if (!(version instanceof ZkVersion)) {
                LOG.info("Not an instance of ZKVersion: {}", (Object)ledgerId);
                cb.operationComplete(-17, null);
                return;
            }
            znodeVersion = ((ZkVersion)version).getZnodeVersion();
        }
        this.zk.delete(this.getLedgerPath(ledgerId), znodeVersion, new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                int bkRc;
                if (rc == KeeperException.Code.NONODE.intValue()) {
                    LOG.warn("Ledger node does not exist in ZooKeeper: ledgerId={}", (Object)ledgerId);
                    bkRc = -7;
                } else if (rc == KeeperException.Code.OK.intValue()) {
                    Set listenerSet = (Set)AbstractZkLedgerManager.this.listeners.remove(ledgerId);
                    if (null != listenerSet) {
                        LOG.debug("Remove registered ledger metadata listeners on ledger {} after ledger is deleted.", (Object)ledgerId, (Object)listenerSet);
                    } else {
                        LOG.debug("No ledger metadata listeners to remove from ledger {} when it's being deleted.", (Object)ledgerId);
                    }
                    bkRc = 0;
                } else {
                    bkRc = -9;
                }
                cb.operationComplete(bkRc, null);
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerLedgerMetadataListener(long ledgerId, BookkeeperInternalCallbacks.LedgerMetadataListener listener) {
        if (null != listener) {
            LOG.info("Registered ledger metadata listener {} on ledger {}.", (Object)listener, (Object)ledgerId);
            Set<BookkeeperInternalCallbacks.LedgerMetadataListener> listenerSet = (HashSet<BookkeeperInternalCallbacks.LedgerMetadataListener>)this.listeners.get(ledgerId);
            if (listenerSet == null) {
                HashSet<BookkeeperInternalCallbacks.LedgerMetadataListener> newListenerSet = new HashSet<BookkeeperInternalCallbacks.LedgerMetadataListener>();
                Set oldListenerSet = this.listeners.putIfAbsent(ledgerId, newListenerSet);
                listenerSet = null != oldListenerSet ? oldListenerSet : newListenerSet;
            }
            HashSet<BookkeeperInternalCallbacks.LedgerMetadataListener> hashSet = listenerSet;
            synchronized (hashSet) {
                listenerSet.add(listener);
            }
            new ReadLedgerMetadataTask(ledgerId).run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterLedgerMetadataListener(long ledgerId, BookkeeperInternalCallbacks.LedgerMetadataListener listener) {
        Set listenerSet = (Set)this.listeners.get(ledgerId);
        if (listenerSet != null) {
            Set set = listenerSet;
            synchronized (set) {
                if (listenerSet.remove(listener)) {
                    LOG.info("Unregistered ledger metadata listener {} on ledger {}.", (Object)listener, (Object)ledgerId);
                }
                if (listenerSet.isEmpty()) {
                    this.listeners.remove(ledgerId, listenerSet);
                }
            }
        }
    }

    @Override
    public void readLedgerMetadata(long ledgerId, BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata> readCb) {
        this.readLedgerMetadata(ledgerId, readCb, null);
    }

    protected void readLedgerMetadata(final long ledgerId, final BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata> readCb, Watcher watcher) {
        this.zk.getData(this.getLedgerPath(ledgerId), watcher, new AsyncCallback.DataCallback(){

            public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                LedgerMetadata metadata;
                if (rc == KeeperException.Code.NONODE.intValue()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No such ledger: " + ledgerId, (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                    }
                    readCb.operationComplete(-7, null);
                    return;
                }
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("Could not read metadata for ledger: " + ledgerId, (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                    readCb.operationComplete(-9, null);
                    return;
                }
                try {
                    metadata = LedgerMetadata.parseConfig(data, new ZkVersion(stat.getVersion()));
                }
                catch (IOException e) {
                    LOG.error("Could not parse ledger metadata for ledger: " + ledgerId, (Throwable)e);
                    readCb.operationComplete(-9, null);
                    return;
                }
                readCb.operationComplete(0, metadata);
            }
        }, null);
    }

    @Override
    public void writeLedgerMetadata(long ledgerId, final LedgerMetadata metadata, final BookkeeperInternalCallbacks.GenericCallback<Void> cb) {
        Version v = metadata.getVersion();
        if (Version.NEW == v || !(v instanceof ZkVersion)) {
            cb.operationComplete(-17, null);
            return;
        }
        final ZkVersion zv = (ZkVersion)v;
        this.zk.setData(this.getLedgerPath(ledgerId), metadata.serialize(), zv.getZnodeVersion(), new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                if (-103 == rc) {
                    cb.operationComplete(-17, null);
                } else if (KeeperException.Code.OK.intValue() == rc) {
                    metadata.setVersion(zv.setZnodeVersion(stat.getVersion()));
                    cb.operationComplete(0, null);
                } else {
                    LOG.warn("Conditional update ledger metadata failed: ", (Object)KeeperException.Code.get((int)rc));
                    cb.operationComplete(-9, null);
                }
            }
        }, null);
    }

    protected void asyncProcessLedgersInSingleNode(final String path, final BookkeeperInternalCallbacks.Processor<Long> processor, final AsyncCallback.VoidCallback finalCb, final Object ctx, final int successRc, final int failureRc) {
        ZkUtils.getChildrenInSingleNode(this.zk, path, new BookkeeperInternalCallbacks.GenericCallback<List<String>>(){

            @Override
            public void operationComplete(int rc, List<String> ledgerNodes) {
                if (KeeperException.Code.OK.intValue() != rc) {
                    finalCb.processResult(failureRc, null, ctx);
                    return;
                }
                NavigableSet<Long> zkActiveLedgers = AbstractZkLedgerManager.this.ledgerListToSet(ledgerNodes, path);
                LOG.debug("Processing ledgers: {}", zkActiveLedgers);
                if (zkActiveLedgers.size() == 0) {
                    finalCb.processResult(successRc, null, ctx);
                    return;
                }
                BookkeeperInternalCallbacks.MultiCallback mcb = new BookkeeperInternalCallbacks.MultiCallback(zkActiveLedgers.size(), finalCb, ctx, successRc, failureRc);
                for (Long ledger : zkActiveLedgers) {
                    processor.process(ledger, mcb);
                }
            }
        });
    }

    protected boolean isSpecialZnode(String znode) {
        return "available".equals(znode) || "cookies".equals(znode) || "LAYOUT".equals(znode) || "INSTANCEID".equals(znode) || "underreplication".equals(znode);
    }

    protected NavigableSet<Long> ledgerListToSet(List<String> ledgerNodes, String path) {
        TreeSet<Long> zkActiveLedgers = new TreeSet<Long>();
        for (String ledgerNode : ledgerNodes) {
            if (this.isSpecialZnode(ledgerNode)) continue;
            try {
                zkActiveLedgers.add(this.getLedgerId(path + "/" + ledgerNode));
            }
            catch (IOException e) {
                LOG.warn("Error extracting ledgerId from ZK ledger node: " + ledgerNode);
            }
        }
        return zkActiveLedgers;
    }

    @Override
    public void close() {
        try {
            this.scheduler.shutdown();
        }
        catch (Exception e) {
            LOG.warn("Error when closing zookeeper based ledger manager: ", (Throwable)e);
        }
    }

    protected class ReadLedgerMetadataTask
    implements Runnable,
    BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata> {
        final long ledgerId;

        ReadLedgerMetadataTask(long ledgerId) {
            this.ledgerId = ledgerId;
        }

        @Override
        public void run() {
            if (null != AbstractZkLedgerManager.this.listeners.get(this.ledgerId)) {
                LOG.debug("Re-read ledger metadata for {}.", (Object)this.ledgerId);
                AbstractZkLedgerManager.this.readLedgerMetadata(this.ledgerId, this, AbstractZkLedgerManager.this);
            } else {
                LOG.debug("Ledger metadata listener for ledger {} is already removed.", (Object)this.ledgerId);
            }
        }

        @Override
        public void operationComplete(int rc, final LedgerMetadata result) {
            if (0 == rc) {
                final Set listenerSet = (Set)AbstractZkLedgerManager.this.listeners.get(this.ledgerId);
                if (null != listenerSet) {
                    LOG.debug("Ledger metadata is changed for {} : {}.", (Object)this.ledgerId, (Object)result);
                    AbstractZkLedgerManager.this.scheduler.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Set set = listenerSet;
                            synchronized (set) {
                                for (BookkeeperInternalCallbacks.LedgerMetadataListener listener : listenerSet) {
                                    listener.onChanged(ReadLedgerMetadataTask.this.ledgerId, result);
                                }
                            }
                        }
                    });
                }
            } else if (-7 == rc) {
                Set listenerSet = (Set)AbstractZkLedgerManager.this.listeners.remove(this.ledgerId);
                if (null != listenerSet) {
                    LOG.debug("Removed ledger metadata listener set on ledger {} as its ledger is deleted : {}", (Object)this.ledgerId, (Object)listenerSet.size());
                }
            } else {
                LOG.warn("Failed on read ledger metadata of ledger {} : {}", (Object)this.ledgerId, (Object)rc);
                AbstractZkLedgerManager.this.scheduler.schedule(this, (long)ZK_CONNECT_BACKOFF_MS, TimeUnit.MILLISECONDS);
            }
        }
    }
}

