/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import org.apache.bookkeeper.versioning.Version;

public class ZkVersion
implements Version {
    int znodeVersion;

    public ZkVersion(int version) {
        this.znodeVersion = version;
    }

    @Override
    public Version.Occurred compare(Version v) {
        if (null == v) {
            throw new NullPointerException("Version is not allowed to be null.");
        }
        if (v == Version.NEW) {
            return Version.Occurred.AFTER;
        }
        if (v == Version.ANY) {
            return Version.Occurred.CONCURRENTLY;
        }
        if (!(v instanceof ZkVersion)) {
            throw new IllegalArgumentException("Invalid version type");
        }
        ZkVersion zv = (ZkVersion)v;
        int res = this.znodeVersion - zv.znodeVersion;
        if (res == 0) {
            return Version.Occurred.CONCURRENTLY;
        }
        if (res < 0) {
            return Version.Occurred.BEFORE;
        }
        return Version.Occurred.AFTER;
    }

    public int getZnodeVersion() {
        return this.znodeVersion;
    }

    public ZkVersion setZnodeVersion(int znodeVersion) {
        this.znodeVersion = znodeVersion;
        return this;
    }

    public String toString() {
        return Integer.toString(this.znodeVersion, 10);
    }
}

