/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalBookKeeper {
    protected static final Logger LOG = LoggerFactory.getLogger(LocalBookKeeper.class);
    public static final int CONNECTION_TIMEOUT = 30000;
    int numberOfBookies = 3;
    private final String HOSTPORT = "127.0.0.1:2181";
    NIOServerCnxnFactory serverFactory;
    ZooKeeperServer zks;
    ZooKeeper zkc;
    int ZooKeeperDefaultPort = 2181;
    static int zkSessionTimeOut = 5000;
    File ZkTmpDir;
    File[] tmpDirs;
    BookieServer[] bs;
    ServerConfiguration[] bsConfs;
    Integer initialPort = 5000;

    public LocalBookKeeper() {
    }

    public LocalBookKeeper(int numberOfBookies) {
        this();
        this.numberOfBookies = numberOfBookies;
        LOG.info("Running " + this.numberOfBookies + " bookie(s).");
    }

    private void runZookeeper(int maxCC) throws IOException {
        LOG.info("Starting ZK server");
        this.ZkTmpDir = File.createTempFile("zookeeper", "test");
        if (!this.ZkTmpDir.delete() || !this.ZkTmpDir.mkdir()) {
            throw new IOException("Couldn't create zk directory " + this.ZkTmpDir);
        }
        try {
            this.zks = new ZooKeeperServer(this.ZkTmpDir, this.ZkTmpDir, this.ZooKeeperDefaultPort);
            this.serverFactory = new NIOServerCnxnFactory();
            this.serverFactory.configure(new InetSocketAddress(this.ZooKeeperDefaultPort), maxCC);
            this.serverFactory.startup(this.zks);
        }
        catch (Exception e) {
            LOG.error("Exception while instantiating ZooKeeper", (Throwable)e);
        }
        boolean b = LocalBookKeeper.waitForServerUp("127.0.0.1:2181", 30000L);
        LOG.debug("ZooKeeper server up: {}", (Object)b);
    }

    private void initializeZookeper() throws IOException {
        LOG.info("Instantiate ZK Client");
        try {
            ZKConnectionWatcher zkConnectionWatcher = new ZKConnectionWatcher();
            this.zkc = new ZooKeeper("127.0.0.1:2181", zkSessionTimeOut, (Watcher)zkConnectionWatcher);
            zkConnectionWatcher.waitForConnection();
            this.zkc.create("/ledgers", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            this.zkc.create("/ledgers/available", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException e) {
            LOG.error("Exception while creating znodes", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while creating znodes", (Throwable)e);
        }
    }

    private void runBookies(ServerConfiguration baseConf) throws IOException, KeeperException, InterruptedException, BookieException, ReplicationException.UnavailableException, ReplicationException.CompatibilityException {
        LOG.info("Starting Bookie(s)");
        this.tmpDirs = new File[this.numberOfBookies];
        this.bs = new BookieServer[this.numberOfBookies];
        this.bsConfs = new ServerConfiguration[this.numberOfBookies];
        for (int i = 0; i < this.numberOfBookies; ++i) {
            this.tmpDirs[i] = File.createTempFile("bookie" + Integer.toString(i), "test");
            if (!this.tmpDirs[i].delete() || !this.tmpDirs[i].mkdir()) {
                throw new IOException("Couldn't create bookie dir " + this.tmpDirs[i]);
            }
            this.bsConfs[i] = new ServerConfiguration(baseConf);
            this.bsConfs[i].setBookiePort(this.initialPort + i);
            this.bsConfs[i].setZkServers(InetAddress.getLocalHost().getHostAddress() + ":" + this.ZooKeeperDefaultPort);
            this.bsConfs[i].setJournalDirName(this.tmpDirs[i].getPath());
            this.bsConfs[i].setLedgerDirNames(new String[]{this.tmpDirs[i].getPath()});
            this.bsConfs[i].setAllowLoopback(true);
            this.bs[i] = new BookieServer(this.bsConfs[i]);
            this.bs[i].start();
        }
    }

    public static void main(String[] args) throws IOException, KeeperException, InterruptedException, BookieException, ReplicationException.UnavailableException, ReplicationException.CompatibilityException {
        if (args.length < 1) {
            LocalBookKeeper.usage();
            System.exit(-1);
        }
        LocalBookKeeper lb = new LocalBookKeeper(Integer.parseInt(args[0]));
        ServerConfiguration conf = new ServerConfiguration();
        if (args.length >= 2) {
            String confFile = args[1];
            try {
                conf.loadConf(new File(confFile).toURI().toURL());
                LOG.info("Using configuration file " + confFile);
            }
            catch (Exception e) {
                LOG.warn("Error loading configuration file " + confFile, (Throwable)e);
            }
        }
        lb.runZookeeper(1000);
        lb.initializeZookeper();
        lb.runBookies(conf);
        while (true) {
            Thread.sleep(5000L);
        }
    }

    private static void usage() {
        System.err.println("Usage: LocalBookKeeper number-of-bookies");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitForServerUp(String hp, long timeout) {
        long start = MathUtils.now();
        String[] split = hp.split(":");
        String host = split[0];
        int port = Integer.parseInt(split[1]);
        while (true) {
            try {
                Socket sock = new Socket(host, port);
                BufferedReader reader = null;
                try {
                    OutputStream outstream = sock.getOutputStream();
                    outstream.write("stat".getBytes());
                    outstream.flush();
                    reader = new BufferedReader(new InputStreamReader(sock.getInputStream()));
                    String line = reader.readLine();
                    if (line != null && line.startsWith("Zookeeper version:")) {
                        LOG.info("Server UP");
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    sock.close();
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                LOG.info("server " + hp + " not up " + e);
            }
            if (MathUtils.now() > start + timeout) {
                return false;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
            }
        }
    }

    static class ZKConnectionWatcher
    implements Watcher {
        private CountDownLatch clientConnectLatch = new CountDownLatch(1);

        ZKConnectionWatcher() {
        }

        public void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                this.clientConnectLatch.countDown();
            }
        }

        public void waitForConnection() throws IOException {
            try {
                if (!this.clientConnectLatch.await(zkSessionTimeOut, TimeUnit.MILLISECONDS)) {
                    throw new IOException("Couldn't connect to zookeeper server");
                }
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted when connecting to zookeeper server", e);
            }
        }
    }
}

