/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.zookeeper.ZooKeeperWatcherBase;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ZkUtils.class);

    public static void asyncCreateFullPathOptimistic(final ZooKeeper zk, final String originalPath, final byte[] data, final List<ACL> acl, final CreateMode createMode, final AsyncCallback.StringCallback callback, Object ctx) {
        zk.create(originalPath, data, acl, createMode, new AsyncCallback.StringCallback(){

            public void processResult(int rc, String path, Object ctx, String name) {
                if (rc != KeeperException.Code.NONODE.intValue()) {
                    callback.processResult(rc, path, ctx, name);
                    return;
                }
                String parent = new File(originalPath).getParent().replace("\\", "/");
                ZkUtils.asyncCreateFullPathOptimistic(zk, parent, new byte[0], acl, CreateMode.PERSISTENT, new AsyncCallback.StringCallback(){

                    public void processResult(int rc, String path, Object ctx, String name) {
                        if (rc == KeeperException.Code.OK.intValue() || rc == KeeperException.Code.NODEEXISTS.intValue()) {
                            ZkUtils.asyncCreateFullPathOptimistic(zk, originalPath, data, acl, createMode, callback, ctx);
                        } else {
                            callback.processResult(rc, path, ctx, name);
                        }
                    }
                }, ctx);
            }
        }, ctx);
    }

    public static void createFullPathOptimistic(ZooKeeper zkc, String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger rc = new AtomicInteger(KeeperException.Code.OK.intValue());
        ZkUtils.asyncCreateFullPathOptimistic(zkc, path, data, acl, createMode, new AsyncCallback.StringCallback(){

            public void processResult(int rc2, String path, Object ctx, String name) {
                rc.set(rc2);
                latch.countDown();
            }
        }, null);
        latch.await();
        if (rc.get() != KeeperException.Code.OK.intValue()) {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getChildrenInSingleNode(ZooKeeper zk, String node) throws InterruptedException, IOException {
        final GetChildrenCtx ctx = new GetChildrenCtx();
        ZkUtils.getChildrenInSingleNode(zk, node, new BookkeeperInternalCallbacks.GenericCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(int rc, List<String> ledgers) {
                GetChildrenCtx getChildrenCtx = ctx;
                synchronized (getChildrenCtx) {
                    if (KeeperException.Code.OK.intValue() == rc) {
                        ctx.children = ledgers;
                    }
                    ctx.rc = rc;
                    ctx.done = true;
                    ctx.notifyAll();
                }
            }
        });
        GetChildrenCtx getChildrenCtx = ctx;
        synchronized (getChildrenCtx) {
            while (!ctx.done) {
                ctx.wait();
            }
        }
        if (KeeperException.Code.OK.intValue() != ctx.rc) {
            throw new IOException("Error on getting children from node " + node);
        }
        return ctx.children;
    }

    public static void getChildrenInSingleNode(final ZooKeeper zk, final String node, final BookkeeperInternalCallbacks.GenericCallback<List<String>> cb) {
        zk.sync(node, new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("ZK error syncing nodes when getting children: ", (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                    cb.operationComplete(rc, null);
                    return;
                }
                zk.getChildren(node, false, new AsyncCallback.ChildrenCallback(){

                    public void processResult(int rc, String path, Object ctx, List<String> nodes) {
                        if (rc != KeeperException.Code.OK.intValue()) {
                            LOG.error("Error polling ZK for the available nodes: ", (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                            cb.operationComplete(rc, null);
                            return;
                        }
                        cb.operationComplete(rc, nodes);
                    }
                }, null);
            }
        }, null);
    }

    public static ZooKeeper createConnectedZookeeperClient(String servers, ZooKeeperWatcherBase w) throws IOException, InterruptedException, KeeperException {
        if (servers == null || servers.isEmpty()) {
            throw new IllegalArgumentException("servers cannot be empty");
        }
        ZooKeeper newZk = new ZooKeeper(servers, w.getZkSessionTimeOut(), (Watcher)w);
        w.waitForConnection();
        if (!newZk.getState().isConnected()) {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.CONNECTIONLOSS);
        }
        return newZk;
    }

    private static class GetChildrenCtx {
        int rc;
        boolean done = false;
        List<String> children = null;

        private GetChildrenCtx() {
        }
    }
}

