/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang3.ArrayUtils;

public final class RequestValidations {
    public static void checkTrue(boolean expression, String message) throws InvalidRequestException {
        RequestValidations.checkTrue(expression, message, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public static void checkTrue(boolean expression, String messageTemplate, Object ... messageArgs) throws InvalidRequestException {
        if (!expression) {
            throw RequestValidations.invalidRequest(messageTemplate, messageArgs);
        }
    }

    public static void checkContainsNoDuplicates(List<?> list, String message) throws InvalidRequestException {
        if (new HashSet(list).size() != list.size()) {
            throw RequestValidations.invalidRequest(message, new Object[0]);
        }
    }

    public static <E> void checkContainsOnly(List<E> list, List<E> expectedElements, String message) throws InvalidRequestException {
        ArrayList<E> copy = new ArrayList<E>(list);
        copy.removeAll(expectedElements);
        if (!copy.isEmpty()) {
            throw RequestValidations.invalidRequest(message, new Object[0]);
        }
    }

    public static void checkFalse(boolean expression, String messageTemplate, Object ... messageArgs) throws InvalidRequestException {
        RequestValidations.checkTrue(!expression, messageTemplate, messageArgs);
    }

    public static void checkFalse(boolean expression, String message) throws InvalidRequestException {
        RequestValidations.checkTrue(!expression, message);
    }

    public static <T> T checkNotNull(T object, String messageTemplate, Object ... messageArgs) throws InvalidRequestException {
        RequestValidations.checkTrue(object != null, messageTemplate, messageArgs);
        return object;
    }

    public static void checkBindValueSet(ByteBuffer b, String messageTemplate, Object ... messageArgs) throws InvalidRequestException {
        RequestValidations.checkTrue(b != ByteBufferUtil.UNSET_BYTE_BUFFER, messageTemplate, messageArgs);
    }

    public static <T> T checkNull(T object, String messageTemplate, Object ... messageArgs) throws InvalidRequestException {
        RequestValidations.checkTrue(object == null, messageTemplate, messageArgs);
        return object;
    }

    public static <T> T checkNull(T object, String message) throws InvalidRequestException {
        return RequestValidations.checkNull(object, message, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public static InvalidRequestException invalidRequest(String messageTemplate, Object ... messageArgs) {
        return new InvalidRequestException(String.format(messageTemplate, messageArgs));
    }

    private RequestValidations() {
    }
}

