/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.lifecycle;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Runnables;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.LogFile;
import org.apache.cassandra.db.lifecycle.LogRecord;
import org.apache.cassandra.db.lifecycle.Tracker;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SnapshotDeletingTask;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.apache.cassandra.utils.concurrent.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LogTransaction
extends Transactional.AbstractTransactional
implements Transactional {
    private static final Logger logger = LoggerFactory.getLogger(LogTransaction.class);
    private final Tracker tracker;
    private final LogFile txnFile;
    private final Ref<LogTransaction> selfRef;
    private static final Queue<Runnable> failedDeletions = new ConcurrentLinkedQueue<Runnable>();

    LogTransaction(OperationType opType) {
        this(opType, null);
    }

    LogTransaction(OperationType opType, Tracker tracker) {
        this.tracker = tracker;
        this.txnFile = new LogFile(opType, UUIDGen.getTimeUUID());
        this.selfRef = new Ref<LogTransaction>(this, new TransactionTidier(this.txnFile));
        if (logger.isTraceEnabled()) {
            logger.trace("Created transaction logs with id {}", (Object)this.txnFile.id());
        }
    }

    void trackNew(SSTable table) {
        this.txnFile.add(LogRecord.Type.ADD, table);
    }

    void untrackNew(SSTable table) {
        this.txnFile.remove(LogRecord.Type.ADD, table);
    }

    SSTableTidier obsoleted(SSTableReader reader) {
        if (this.txnFile.contains(LogRecord.Type.ADD, reader)) {
            if (this.txnFile.contains(LogRecord.Type.REMOVE, reader)) {
                throw new IllegalArgumentException();
            }
            return new SSTableTidier(reader, true, this);
        }
        this.txnFile.add(LogRecord.Type.REMOVE, reader);
        if (this.tracker != null) {
            this.tracker.notifyDeleting(reader);
        }
        return new SSTableTidier(reader, false, this);
    }

    Map<SSTableReader, SSTableTidier> bulkObsoletion(Iterable<SSTableReader> sstables) {
        if (!this.txnFile.isEmpty()) {
            throw new IllegalStateException("Bad state when doing bulk obsoletions");
        }
        this.txnFile.addAll(LogRecord.Type.REMOVE, sstables);
        HashMap<SSTableReader, SSTableTidier> tidiers = new HashMap<SSTableReader, SSTableTidier>();
        for (SSTableReader sstable : sstables) {
            if (this.tracker != null) {
                this.tracker.notifyDeleting(sstable);
            }
            tidiers.put(sstable, new SSTableTidier(sstable, false, this));
        }
        return tidiers;
    }

    OperationType type() {
        return this.txnFile.type();
    }

    UUID id() {
        return this.txnFile.id();
    }

    @VisibleForTesting
    LogFile txnFile() {
        return this.txnFile;
    }

    @VisibleForTesting
    List<File> logFiles() {
        return this.txnFile.getFiles();
    }

    @VisibleForTesting
    List<String> logFilePaths() {
        return this.txnFile.getFilePaths();
    }

    static void delete(File file) {
        block16: {
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace("Deleting {}", (Object)file);
                }
                Files.delete(file.toPath());
            }
            catch (NoSuchFileException e) {
                logger.error("Unable to delete {} as it does not exist, see debug log file for stack trace", (Object)file);
                if (!logger.isDebugEnabled()) break block16;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (PrintStream ps = new PrintStream(baos);){
                    e.printStackTrace(ps);
                }
                logger.debug("Unable to delete {} as it does not exist, stack trace:\n {}", (Object)file, (Object)baos.toString());
            }
            catch (IOException e) {
                logger.error("Unable to delete {}", (Object)file, (Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    static void rescheduleFailedDeletions() {
        Runnable task;
        while (null != (task = failedDeletions.poll())) {
            ScheduledExecutors.nonPeriodicTasks.submit(task);
        }
        SnapshotDeletingTask.rescheduleFailedTasks();
    }

    static void waitForDeletions() {
        FBUtilities.waitOnFuture(ScheduledExecutors.nonPeriodicTasks.schedule(Runnables.doNothing(), 0L, TimeUnit.MILLISECONDS));
    }

    @VisibleForTesting
    Throwable complete(Throwable accumulate) {
        try {
            accumulate = this.selfRef.ensureReleased(accumulate);
            return accumulate;
        }
        catch (Throwable t) {
            logger.error("Failed to complete file transaction id {}", (Object)this.id(), (Object)t);
            return Throwables.merge(accumulate, t);
        }
    }

    @Override
    protected Throwable doCommit(Throwable accumulate) {
        Throwables.DiscreteAction[] discreteActionArray = new Throwables.DiscreteAction[1];
        discreteActionArray[0] = this.txnFile::commit;
        return this.complete(Throwables.perform(accumulate, discreteActionArray));
    }

    @Override
    protected Throwable doAbort(Throwable accumulate) {
        Throwables.DiscreteAction[] discreteActionArray = new Throwables.DiscreteAction[1];
        discreteActionArray[0] = this.txnFile::abort;
        return this.complete(Throwables.perform(accumulate, discreteActionArray));
    }

    @Override
    protected void doPrepare() {
    }

    static boolean removeUnfinishedLeftovers(CFMetaData metadata) {
        return LogTransaction.removeUnfinishedLeftovers(new Directories(metadata, ColumnFamilyStore.getInitialDirectories()).getCFDirectories());
    }

    @VisibleForTesting
    static boolean removeUnfinishedLeftovers(List<File> directories) {
        LogFilesByName logFiles = new LogFilesByName();
        directories.forEach(logFiles::list);
        return logFiles.removeUnfinishedLeftovers();
    }

    private static final class LogFilesByName {
        Map<String, List<File>> files = new HashMap<String, List<File>>();

        private LogFilesByName() {
        }

        void list(File directory) {
            Arrays.stream(directory.listFiles(LogFile::isLogFile)).forEach(this::add);
        }

        void add(File file) {
            List<File> filesByName = this.files.get(file.getName());
            if (filesByName == null) {
                filesByName = new ArrayList<File>();
                this.files.put(file.getName(), filesByName);
            }
            filesByName.add(file);
        }

        boolean removeUnfinishedLeftovers() {
            return this.files.entrySet().stream().map(LogFilesByName::removeUnfinishedLeftovers).allMatch(Predicate.isEqual(true));
        }

        static boolean removeUnfinishedLeftovers(Map.Entry<String, List<File>> entry) {
            try (LogFile txn = LogFile.make(entry.getKey(), entry.getValue());){
                if (txn.verify()) {
                    Throwable failure = txn.removeUnfinishedLeftovers(null);
                    if (failure != null) {
                        logger.error("Failed to remove unfinished transaction leftovers for transaction log {}", (Object)txn.toString(true), (Object)failure);
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                logger.error("Unexpected disk state: failed to read transaction log {}", (Object)txn.toString(true));
                boolean bl = false;
                return bl;
            }
        }
    }

    public static class SSTableTidier
    implements Runnable {
        private final Descriptor desc;
        private final long sizeOnDisk;
        private final Tracker tracker;
        private final boolean wasNew;
        private final Ref<LogTransaction> parentRef;

        public SSTableTidier(SSTableReader referent, boolean wasNew, LogTransaction parent) {
            this.desc = referent.descriptor;
            this.sizeOnDisk = referent.bytesOnDisk();
            this.tracker = parent.tracker;
            this.wasNew = wasNew;
            this.parentRef = parent.selfRef.tryRef();
        }

        @Override
        public void run() {
            if (this.tracker != null && !this.tracker.isDummy()) {
                SystemKeyspace.clearSSTableReadMeter(this.desc.ksname, this.desc.cfname, this.desc.generation);
            }
            try {
                File datafile = new File(this.desc.filenameFor(Component.DATA));
                if (datafile.exists()) {
                    LogTransaction.delete(datafile);
                } else if (!this.wasNew) {
                    logger.error("SSTableTidier ran with no existing data file for an sstable that was not new");
                }
                SSTable.delete(this.desc, SSTable.discoverComponentsFor(this.desc));
            }
            catch (Throwable t) {
                logger.error("Failed deletion for {}, we'll retry after GC and on server restart", (Object)this.desc);
                failedDeletions.add(this);
                return;
            }
            if (this.tracker != null && this.tracker.cfstore != null && !this.wasNew) {
                this.tracker.cfstore.metric.totalDiskSpaceUsed.dec(this.sizeOnDisk);
            }
            this.parentRef.release();
        }

        public void abort() {
            this.parentRef.release();
        }
    }

    static class Obsoletion {
        final SSTableReader reader;
        final SSTableTidier tidier;

        Obsoletion(SSTableReader reader, SSTableTidier tidier) {
            this.reader = reader;
            this.tidier = tidier;
        }
    }

    private static class TransactionTidier
    implements RefCounted.Tidy,
    Runnable {
        private final LogFile data;

        TransactionTidier(LogFile data) {
            this.data = data;
        }

        @Override
        public void tidy() throws Exception {
            this.run();
        }

        @Override
        public String name() {
            return this.data.toString();
        }

        @Override
        public void run() {
            Throwable err;
            if (logger.isTraceEnabled()) {
                logger.trace("Removing files for transaction log {}", (Object)this.data);
            }
            if (!this.data.completed()) {
                logger.error("Transaction log {} indicates txn was not completed, trying to abort it now", (Object)this.data);
                Throwables.DiscreteAction[] discreteActionArray = new Throwables.DiscreteAction[1];
                discreteActionArray[0] = this.data::abort;
                err = Throwables.perform((Throwable)null, discreteActionArray);
                if (err != null) {
                    logger.error("Failed to abort transaction log {}", (Object)this.data, (Object)err);
                }
            }
            if ((err = this.data.removeUnfinishedLeftovers(null)) != null) {
                logger.info("Failed deleting files for transaction log {}, we'll retry after GC and on on server restart", (Object)this.data, (Object)err);
                failedDeletions.add(this);
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("Closing transaction log {}", (Object)this.data);
                }
                this.data.close();
            }
        }
    }

    public static final class CorruptTransactionLogException
    extends RuntimeException {
        public final LogFile txnFile;

        public CorruptTransactionLogException(String message, LogFile txnFile) {
            super(message);
            this.txnFile = txnFile;
        }
    }
}

