/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.nio.ByteBuffer;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;

public class FileSegmentInputStream
extends DataInputBuffer
implements FileDataInput {
    private final String filePath;
    private final long offset;

    public FileSegmentInputStream(ByteBuffer buffer, String filePath, long offset) {
        super(buffer, false);
        this.filePath = filePath;
        this.offset = offset;
    }

    @Override
    public String getPath() {
        return this.filePath;
    }

    private long size() {
        return this.offset + (long)this.buffer.capacity();
    }

    @Override
    public boolean isEOF() {
        return !this.buffer.hasRemaining();
    }

    @Override
    public long bytesRemaining() {
        return this.buffer.remaining();
    }

    @Override
    public void seek(long pos) {
        if (pos < 0L || pos > this.size()) {
            throw new IllegalArgumentException(String.format("Unable to seek to position %d in %s (%d bytes) in partial mode", pos, this.getPath(), this.size()));
        }
        this.buffer.position((int)(pos - this.offset));
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public FileMark mark() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset(FileMark mark) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long bytesPastMark(FileMark mark) {
        return 0L;
    }

    @Override
    public long getFilePointer() {
        return this.offset + (long)this.buffer.position();
    }
}

