/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.coprocessor;

import com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.SecureBulkLoadProtos;
import org.apache.hadoop.hbase.security.SecureBulkLoadUtil;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
public class SecureBulkLoadClient {
    private Table table;

    public SecureBulkLoadClient(Table table) {
        this.table = table;
    }

    public String prepareBulkLoad(TableName tableName) throws IOException {
        try {
            CoprocessorRpcChannel channel = this.table.coprocessorService(HConstants.EMPTY_START_ROW);
            SecureBulkLoadProtos.SecureBulkLoadService instance = ProtobufUtil.newServiceStub(SecureBulkLoadProtos.SecureBulkLoadService.class, channel);
            ServerRpcController controller = new ServerRpcController();
            BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
            SecureBulkLoadProtos.PrepareBulkLoadRequest request = SecureBulkLoadProtos.PrepareBulkLoadRequest.newBuilder().setTableName(ProtobufUtil.toProtoTableName(tableName)).build();
            instance.prepareBulkLoad((RpcController)controller, request, rpcCallback);
            SecureBulkLoadProtos.PrepareBulkLoadResponse response = (SecureBulkLoadProtos.PrepareBulkLoadResponse)rpcCallback.get();
            if (controller.failedOnException()) {
                throw controller.getFailedOn();
            }
            return response.getBulkToken();
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public void cleanupBulkLoad(String bulkToken) throws IOException {
        try {
            CoprocessorRpcChannel channel = this.table.coprocessorService(HConstants.EMPTY_START_ROW);
            SecureBulkLoadProtos.SecureBulkLoadService instance = ProtobufUtil.newServiceStub(SecureBulkLoadProtos.SecureBulkLoadService.class, channel);
            ServerRpcController controller = new ServerRpcController();
            BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
            SecureBulkLoadProtos.CleanupBulkLoadRequest request = SecureBulkLoadProtos.CleanupBulkLoadRequest.newBuilder().setBulkToken(bulkToken).build();
            instance.cleanupBulkLoad((RpcController)controller, request, rpcCallback);
            if (controller.failedOnException()) {
                throw controller.getFailedOn();
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public boolean bulkLoadHFiles(List<Pair<byte[], String>> familyPaths, Token<?> userToken, String bulkToken, byte[] startRow) throws IOException {
        try {
            CoprocessorRpcChannel channel = this.table.coprocessorService(startRow);
            SecureBulkLoadProtos.SecureBulkLoadService instance = ProtobufUtil.newServiceStub(SecureBulkLoadProtos.SecureBulkLoadService.class, channel);
            SecureBulkLoadProtos.DelegationToken protoDT = SecureBulkLoadProtos.DelegationToken.newBuilder().build();
            if (userToken != null) {
                protoDT = SecureBulkLoadProtos.DelegationToken.newBuilder().setIdentifier(ByteStringer.wrap((byte[])userToken.getIdentifier())).setPassword(ByteStringer.wrap((byte[])userToken.getPassword())).setKind(userToken.getKind().toString()).setService(userToken.getService().toString()).build();
            }
            ArrayList<ClientProtos.BulkLoadHFileRequest.FamilyPath> protoFamilyPaths = new ArrayList<ClientProtos.BulkLoadHFileRequest.FamilyPath>();
            for (Pair<byte[], String> el : familyPaths) {
                protoFamilyPaths.add(ClientProtos.BulkLoadHFileRequest.FamilyPath.newBuilder().setFamily(ByteStringer.wrap((byte[])((byte[])el.getFirst()))).setPath((String)el.getSecond()).build());
            }
            SecureBulkLoadProtos.SecureBulkLoadHFilesRequest request = SecureBulkLoadProtos.SecureBulkLoadHFilesRequest.newBuilder().setFsToken(protoDT).addAllFamilyPath(protoFamilyPaths).setBulkToken(bulkToken).build();
            ServerRpcController controller = new ServerRpcController();
            BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
            instance.secureBulkLoadHFiles((RpcController)controller, request, rpcCallback);
            SecureBulkLoadProtos.SecureBulkLoadHFilesResponse response = (SecureBulkLoadProtos.SecureBulkLoadHFilesResponse)rpcCallback.get();
            if (controller.failedOnException()) {
                throw controller.getFailedOn();
            }
            return response.getLoaded();
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public Path getStagingPath(String bulkToken, byte[] family) throws IOException {
        return SecureBulkLoadUtil.getStagingPath(this.table.getConfiguration(), bulkToken, family);
    }
}

