package org.apache.maven.artifact.resolver.filter;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.maven.artifact.Artifact;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * @author <a href="mailto:jason@maven.org">Jason van Zyl</a>
 * @version $Id: ExclusionSetFilter.java 163668 2005-03-23 03:40:13Z brett $
 */
public class ExclusionSetFilter
    implements ArtifactFilter
{
    private Set excludes;

    public ExclusionSetFilter( String[] excludes )
    {
        this.excludes = new HashSet( Arrays.asList( excludes ) );
    }

    public ExclusionSetFilter( Set excludes )
    {
        this.excludes = excludes;
    }

    public boolean include( Artifact artifact )
    {
        if ( excludes.contains( artifact.getArtifactId() ) )
        {
            return false;
        }

        return true;
    }
}
