/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.artifact;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugins.assembly.archive.phase.ModuleSetAssemblyPhase;
import org.apache.maven.plugins.assembly.artifact.DependencyResolutionException;
import org.apache.maven.plugins.assembly.artifact.DependencyResolver;
import org.apache.maven.plugins.assembly.artifact.ResolutionManagementInfo;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.ModuleBinaries;
import org.apache.maven.plugins.assembly.model.ModuleSet;
import org.apache.maven.plugins.assembly.model.Repository;
import org.apache.maven.plugins.assembly.resolved.AssemblyId;
import org.apache.maven.plugins.assembly.utils.FilterUtils;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.artifact.filter.resolve.transform.ArtifactIncludeFilterTransformer;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.dependencies.resolve.DependencyResolverException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

@Component(role=DependencyResolver.class)
public class DefaultDependencyResolver
extends AbstractLogEnabled
implements DependencyResolver {
    @Requirement
    private RepositorySystem resolver;
    @Requirement
    private org.apache.maven.shared.dependencies.resolve.DependencyResolver dependencyResolver;

    @Override
    public Map<DependencySet, Set<Artifact>> resolveDependencySets(Assembly assembly, ModuleSet moduleSet, AssemblerConfigurationSource configSource, List<DependencySet> dependencySets) throws DependencyResolutionException {
        LinkedHashMap<DependencySet, Set<Artifact>> result = new LinkedHashMap<DependencySet, Set<Artifact>>();
        for (DependencySet dependencySet : dependencySets) {
            MavenProject currentProject = configSource.getProject();
            ResolutionManagementInfo info = new ResolutionManagementInfo(currentProject);
            this.updateRepositoryResolutionRequirements(assembly, info);
            AssemblyId assemblyId = AssemblyId.createAssemblyId(assembly);
            this.updateDependencySetResolutionRequirements(dependencySet, info, assemblyId, configSource.getMavenSession().getProjectBuildingRequest(), currentProject);
            this.updateModuleSetResolutionRequirements(assemblyId, moduleSet, dependencySet, info, configSource);
            this.resolve(assembly, configSource, result, dependencySet, info);
        }
        return result;
    }

    private void resolve(Assembly assembly, AssemblerConfigurationSource configSource, Map<DependencySet, Set<Artifact>> result, DependencySet dependencySet, ResolutionManagementInfo info) throws DependencyResolutionException {
        Set<Object> artifacts;
        if (info.isResolutionRequired()) {
            List<ArtifactRepository> repos = this.aggregateRemoteArtifactRepositories(configSource.getRemoteRepositories(), info.getEnabledProjects());
            artifacts = info.getArtifacts();
            if (info.isResolvedTransitively()) {
                this.getLogger().debug("Resolving project dependencies transitively.");
                ArtifactFilter filter = new ArtifactIncludeFilterTransformer().transform(info.getScopeFilter());
                artifacts = this.resolveTransitively(artifacts, repos, filter, configSource);
            } else {
                this.getLogger().debug("Resolving project dependencies ONLY. Transitive dependencies WILL NOT be included in the results.");
                artifacts = this.resolveNonTransitively(assembly, artifacts, configSource, repos);
            }
        } else {
            artifacts = new HashSet();
        }
        result.put(dependencySet, artifacts);
    }

    @Override
    public Map<DependencySet, Set<Artifact>> resolveDependencySets(Assembly assembly, AssemblerConfigurationSource configSource, List<DependencySet> dependencySets) throws DependencyResolutionException {
        LinkedHashMap<DependencySet, Set<Artifact>> result = new LinkedHashMap<DependencySet, Set<Artifact>>();
        for (DependencySet dependencySet : dependencySets) {
            MavenProject currentProject = configSource.getProject();
            ResolutionManagementInfo info = new ResolutionManagementInfo(currentProject);
            this.updateRepositoryResolutionRequirements(assembly, info);
            AssemblyId assemblyId = AssemblyId.createAssemblyId(assembly);
            this.updateDependencySetResolutionRequirements(dependencySet, info, assemblyId, configSource.getMavenSession().getProjectBuildingRequest(), currentProject);
            this.resolve(assembly, configSource, result, dependencySet, info);
        }
        return result;
    }

    Set<Artifact> resolveNonTransitively(Assembly assembly, Set<Artifact> dependencyArtifacts, AssemblerConfigurationSource configSource, List<ArtifactRepository> repos) throws DependencyResolutionException {
        ArrayList<Artifact> missing = new ArrayList<Artifact>();
        LinkedHashSet<Artifact> resolved = new LinkedHashSet<Artifact>();
        for (Artifact depArtifact : dependencyArtifacts) {
            ArtifactResolutionRequest req = new ArtifactResolutionRequest();
            req.setLocalRepository(configSource.getLocalRepository());
            req.setRemoteRepositories(repos);
            req.setArtifact(depArtifact);
            ArtifactResolutionResult resolve = this.resolver.resolve(req);
            if (resolve.hasExceptions()) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Failed to resolve: " + depArtifact.getId() + " for assembly: " + assembly.getId());
                }
                missing.add(depArtifact);
                continue;
            }
            resolved.add(depArtifact);
        }
        if (!missing.isEmpty()) {
            MavenProject project = configSource.getProject();
            Artifact rootArtifact = project.getArtifact();
            MultipleArtifactsNotFoundException error = new MultipleArtifactsNotFoundException(rootArtifact, new ArrayList<Artifact>(resolved), missing, repos);
            throw new DependencyResolutionException("Failed to resolve dependencies for: " + assembly.getId(), (Throwable)error);
        }
        return resolved;
    }

    private Set<Artifact> resolveTransitively(Set<Artifact> dependencyArtifacts, List<ArtifactRepository> repos, ArtifactFilter filter, AssemblerConfigurationSource configSource) throws DependencyResolutionException {
        MavenProject project = configSource.getProject();
        ArtifactResolutionRequest req = new ArtifactResolutionRequest();
        req.setLocalRepository(configSource.getLocalRepository());
        req.setResolveRoot(false);
        req.setRemoteRepositories(repos);
        req.setResolveTransitively(true);
        req.setArtifact(project.getArtifact());
        req.setArtifactDependencies(dependencyArtifacts);
        req.setManagedVersionMap(project.getManagedVersionMap());
        req.setCollectionFilter(filter);
        req.setOffline(configSource.getMavenSession().isOffline());
        req.setForceUpdate(configSource.getMavenSession().getRequest().isUpdateSnapshots());
        req.setServers(configSource.getMavenSession().getRequest().getServers());
        req.setMirrors(configSource.getMavenSession().getRequest().getMirrors());
        req.setProxies(configSource.getMavenSession().getRequest().getProxies());
        ArtifactResolutionResult result = this.resolver.resolve(req);
        if (result.hasExceptions()) {
            throw new DependencyResolutionException("Failed to resolve dependencies for assembly: ", (Throwable)result.getExceptions().get(0));
        }
        this.getLogger().debug("While resolving dependencies of " + project.getId() + ":");
        FilterUtils.reportFilteringStatistics(Collections.singleton(filter), this.getLogger());
        return result.getArtifacts();
    }

    void updateRepositoryResolutionRequirements(Assembly assembly, ResolutionManagementInfo requirements) {
        List<Repository> repositories = assembly.getRepositories();
        HashSet<String> rootScopes = new HashSet<String>();
        if (repositories != null && !repositories.isEmpty()) {
            requirements.setResolutionRequired(true);
            for (Repository repo : repositories) {
                rootScopes.add(repo.getScope());
            }
        }
        requirements.setScopeFilter(FilterUtils.newScopeFilter(rootScopes));
    }

    void updateModuleSetResolutionRequirements(AssemblyId assemblyId, ModuleSet set, DependencySet dependencySet, ResolutionManagementInfo requirements, AssemblerConfigurationSource configSource) throws DependencyResolutionException {
        ModuleBinaries binaries = set.getBinaries();
        if (binaries != null) {
            Set<MavenProject> projects;
            try {
                projects = ModuleSetAssemblyPhase.getModuleProjects(set, configSource, this.getLogger());
            }
            catch (ArchiveCreationException e) {
                throw new DependencyResolutionException("Error determining project-set for moduleSet with binaries.", e);
            }
            if (!projects.isEmpty()) {
                for (MavenProject p : projects) {
                    requirements.enableProjectResolution(p);
                    if (p.getArtifact() != null) continue;
                    Artifact artifact = this.resolver.createArtifact(p.getGroupId(), p.getArtifactId(), p.getVersion(), p.getPackaging());
                    p.setArtifact(artifact);
                }
            }
            if (binaries.isIncludeDependencies()) {
                this.updateDependencySetResolutionRequirements(dependencySet, requirements, assemblyId, configSource.getMavenSession().getProjectBuildingRequest(), projects.toArray(new MavenProject[projects.size()]));
            }
        }
    }

    void updateDependencySetResolutionRequirements(DependencySet set, ResolutionManagementInfo requirements, AssemblyId assemblyId, ProjectBuildingRequest buildingRequest, MavenProject ... projects) throws DependencyResolutionException {
        requirements.setResolutionRequired(true);
        requirements.setResolvedTransitively(set.isUseTransitiveDependencies());
        ScopeFilter scopeFilter = FilterUtils.newScopeFilter(set.getScope());
        requirements.setScopeFilter(scopeFilter);
        for (MavenProject project : projects) {
            if (project == null) continue;
            HashSet<Artifact> dependencyArtifacts = project.getDependencyArtifacts();
            if (dependencyArtifacts == null) {
                try {
                    DefaultProjectBuildingRequest pbr = new DefaultProjectBuildingRequest(buildingRequest);
                    pbr.setRemoteRepositories(project.getRemoteArtifactRepositories());
                    Iterable artifactResults = this.dependencyResolver.resolveDependencies((ProjectBuildingRequest)pbr, project.getModel(), (TransformableFilter)scopeFilter);
                    dependencyArtifacts = new HashSet<Artifact>();
                    for (ArtifactResult artifactResult : artifactResults) {
                        dependencyArtifacts.add(artifactResult.getArtifact());
                    }
                    project.setDependencyArtifacts(dependencyArtifacts);
                }
                catch (DependencyResolverException e) {
                    throw new DependencyResolutionException("Failed to create dependency artifacts for resolution. Assembly: " + assemblyId, e);
                }
            }
            requirements.addArtifacts((Set<Artifact>)dependencyArtifacts);
            this.getLogger().debug("Dependencies for project: " + project.getId() + " are:\n" + StringUtils.join(dependencyArtifacts.iterator(), (String)"\n"));
        }
    }

    List<ArtifactRepository> aggregateRemoteArtifactRepositories(List<ArtifactRepository> remoteRepositories, Set<MavenProject> projects) {
        ArrayList<List> repoLists = new ArrayList<List>();
        repoLists.add(remoteRepositories);
        for (MavenProject project : projects) {
            repoLists.add(project.getRemoteArtifactRepositories());
        }
        ArrayList<ArtifactRepository> remoteRepos = new ArrayList<ArtifactRepository>();
        HashSet<String> encounteredUrls = new HashSet<String>();
        for (List repositoryList : repoLists) {
            if (repositoryList == null || repositoryList.isEmpty()) continue;
            for (ArtifactRepository repo : repositoryList) {
                if (encounteredUrls.contains(repo.getUrl())) continue;
                remoteRepos.add(repo);
                encounteredUrls.add(repo.getUrl());
            }
        }
        return remoteRepos;
    }
}

