/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class RuleUtil {
    private static final String CHECKSTYLE_PACKAGE = "com.puppycrawl.tools.checkstyle.checks";

    private RuleUtil() {
    }

    public static String getName(AuditEvent event) {
        return RuleUtil.getName(event.getSourceName());
    }

    public static String getName(String eventSrcName) {
        if (eventSrcName == null) {
            return null;
        }
        if (eventSrcName.endsWith("Check")) {
            eventSrcName = eventSrcName.substring(0, eventSrcName.length() - 5);
        }
        return eventSrcName.substring(eventSrcName.lastIndexOf(46) + 1);
    }

    public static String getCategory(AuditEvent event) {
        return RuleUtil.getCategory(event.getSourceName());
    }

    public static String getCategory(String eventSrcName) {
        if (eventSrcName == null) {
            return null;
        }
        int end = eventSrcName.lastIndexOf(46);
        String string = eventSrcName = end == -1 ? eventSrcName : eventSrcName.substring(0, end);
        if (CHECKSTYLE_PACKAGE.equals(eventSrcName)) {
            return "misc";
        }
        if (!eventSrcName.startsWith(CHECKSTYLE_PACKAGE)) {
            return "extension";
        }
        return eventSrcName.substring(eventSrcName.lastIndexOf(46) + 1);
    }

    public static List<Matcher> parseMatchers(String[] specs) {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (String spec : specs) {
            if (StringUtils.isBlank((CharSequence)spec)) continue;
            Matcher matcher = Character.isUpperCase((spec = spec.trim()).charAt(0)) ? new RuleMatcher(spec) : ("misc".equals(spec) ? new PackageMatcher(CHECKSTYLE_PACKAGE) : ("extension".equals(spec) ? new ExtensionMatcher() : (!spec.contains(".") ? new PackageMatcher("com.puppycrawl.tools.checkstyle.checks." + spec) : new PackageMatcher(spec))));
            matchers.add(matcher);
        }
        return matchers;
    }

    private static class ExtensionMatcher
    implements Matcher {
        private ExtensionMatcher() {
        }

        @Override
        public boolean match(String eventSrcName) {
            return !eventSrcName.startsWith(RuleUtil.CHECKSTYLE_PACKAGE);
        }
    }

    private static class PackageMatcher
    implements Matcher {
        private final String packageName;

        PackageMatcher(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public boolean match(String eventSrcName) {
            return eventSrcName.startsWith(this.packageName) && !eventSrcName.substring(this.packageName.length() + 1).contains(".");
        }
    }

    private static class RuleMatcher
    implements Matcher {
        private final String rule;

        RuleMatcher(String rule) {
            this.rule = rule;
        }

        @Override
        public boolean match(String eventSrcName) {
            return this.rule.equals(RuleUtil.getName(eventSrcName));
        }
    }

    public static interface Matcher {
        public boolean match(String var1);
    }
}

