/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseConfigFile;
import org.apache.maven.plugin.ide.IdeUtils;

public class EclipseCleanMojo
extends AbstractMojo {
    private static final String FILE_DOT_WTPMODULES = ".wtpmodules";
    private static final String FILE_DOT_CLASSPATH = ".classpath";
    private static final String FILE_DOT_PROJECT = ".project";
    private String packaging;
    private File basedir;
    private boolean skip;
    private EclipseConfigFile[] additionalConfig;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        if ("pom".equals(this.packaging)) {
            return;
        }
        this.delete(new File(this.basedir, FILE_DOT_PROJECT));
        this.delete(new File(this.basedir, FILE_DOT_CLASSPATH));
        this.delete(new File(this.basedir, FILE_DOT_WTPMODULES));
        File settingsDir = new File(this.basedir, ".settings");
        if (settingsDir.exists() && settingsDir.isDirectory() && settingsDir.list().length == 0) {
            this.delete(settingsDir);
        }
        if (this.additionalConfig != null) {
            for (int i = 0; i < this.additionalConfig.length; ++i) {
                this.delete(new File(this.basedir, this.additionalConfig[i].getName()));
            }
        }
        this.cleanExtras();
    }

    protected void cleanExtras() throws MojoExecutionException {
    }

    protected void delete(File f) throws MojoExecutionException {
        IdeUtils.delete(f, this.getLog());
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }
}

