/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.wtp;

import java.io.File;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.plugin.ide.JeeUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.XMLWriter;

public abstract class AbstractWtpResourceWriter
extends AbstractEclipseWriter {
    private static final String ELT_DEPENDENCY_OBJECT = "dependent-object";
    private static final String ELT_DEPENDENCY_TYPE = "dependency-type";
    private static final String ATTR_HANDLE = "handle";
    private static final String ELT_DEPENDENT_MODULE = "dependent-module";
    protected static final String ATTR_VALUE = "value";
    protected static final String ATTR_NAME = "name";
    protected static final String ELT_PROPERTY = "property";
    protected static final String ELT_VERSION = "version";
    protected static final String ATTR_MODULE_TYPE_ID = "module-type-id";
    protected static final String ATTR_SOURCE_PATH = "source-path";
    protected static final String ATTR_DEPLOY_PATH = "deploy-path";
    protected static final String ELT_WB_RESOURCE = "wb-resource";
    protected static final String ELT_MODULE_TYPE = "module-type";
    protected static final String ATTR_DEPLOY_NAME = "deploy-name";
    protected static final String ELT_WB_MODULE = "wb-module";
    protected static final String ATTR_MODULE_ID = "id";
    protected static final String ATTR_PROJECT_VERSION = "project-version";
    protected static final String ELT_PROJECT_MODULES = "project-modules";

    protected void writeModuleTypeAccordingToPackaging(MavenProject project, XMLWriter writer, File buildOutputDirectory) throws MojoExecutionException {
        if ("war".equals(this.config.getPackaging())) {
            writer.addAttribute(ATTR_MODULE_TYPE_ID, "jst.web");
            writer.startElement(ELT_VERSION);
            String servletVersion = this.config.getJeeVersion() != null ? JeeUtils.getJeeDescriptorFromJeeVersion(this.config.getJeeVersion()).getServletVersion() : JeeUtils.resolveServletVersion(this.config.getProject());
            writer.writeText(servletVersion);
            writer.endElement();
            String contextRoot = this.config.getContextName();
            writer.startElement(ELT_PROPERTY);
            writer.addAttribute(ATTR_NAME, "context-root");
            writer.addAttribute(ATTR_VALUE, contextRoot);
            writer.endElement();
        } else if ("ejb".equals(this.config.getPackaging())) {
            writer.addAttribute(ATTR_MODULE_TYPE_ID, "jst.ejb");
            writer.startElement(ELT_VERSION);
            String ejbVersion = this.config.getJeeVersion() != null ? JeeUtils.getJeeDescriptorFromJeeVersion(this.config.getJeeVersion()).getEjbVersion() : JeeUtils.resolveEjbVersion(this.config.getProject());
            writer.writeText(ejbVersion);
            writer.endElement();
            writer.startElement(ELT_PROPERTY);
            writer.addAttribute(ATTR_NAME, "java-output-path");
            writer.addAttribute(ATTR_VALUE, "/" + IdeUtils.toRelativeAndFixSeparator(this.config.getProject().getBasedir(), buildOutputDirectory, false));
            writer.endElement();
        } else if ("ear".equals(this.config.getPackaging())) {
            writer.addAttribute(ATTR_MODULE_TYPE_ID, "jst.ear");
            writer.startElement(ELT_VERSION);
            String jeeVersion = this.config.getJeeVersion() != null ? JeeUtils.getJeeDescriptorFromJeeVersion(this.config.getJeeVersion()).getJeeVersion() : JeeUtils.resolveJeeVersion(this.config.getProject());
            writer.writeText(jeeVersion);
            writer.endElement();
        } else {
            writer.addAttribute(ATTR_MODULE_TYPE_ID, "jst.utility");
            writer.startElement(ELT_PROPERTY);
            writer.addAttribute(ATTR_NAME, "java-output-path");
            writer.addAttribute(ATTR_VALUE, "/" + IdeUtils.toRelativeAndFixSeparator(this.config.getProject().getBasedir(), buildOutputDirectory, false));
            writer.endElement();
        }
    }

    protected void addDependency(XMLWriter writer, IdeDependency dep, ArtifactRepository localRepository, File basedir, String deployPath) throws MojoExecutionException {
        String archiveName;
        String handle;
        String dependentObject = null;
        if ("war".equals(dep.getType()) || "ejb".equals(dep.getType())) {
            deployPath = "/";
        }
        if (dep.isReferencedProject()) {
            handle = "module:/resource/" + dep.getEclipseProjectName() + "/" + dep.getEclipseProjectName();
            String archiveExtension = dep.getType();
            if ("ejb".equals(dep.getType())) {
                dependentObject = "EjbModule_";
                archiveExtension = "jar";
            } else if ("war".equals(dep.getType())) {
                dependentObject = "WebModule_";
            }
            archiveName = dep.getEclipseProjectName() + "." + archiveExtension;
        } else {
            File localRepositoryFile;
            String relativePath;
            File artifactPath = dep.getFile();
            if (artifactPath == null) {
                this.log.error((CharSequence)Messages.getString("EclipsePlugin.artifactpathisnull", dep.getId()));
                return;
            }
            String fullPath = artifactPath.getPath();
            File repoFile = new File(fullPath);
            handle = dep.isSystemScoped() ? "module:/classpath/lib/" + IdeUtils.toRelativeAndFixSeparator(this.config.getEclipseProjectDirectory(), repoFile, false) : (!new File(relativePath = IdeUtils.toRelativeAndFixSeparator(localRepositoryFile = new File(localRepository.getBasedir()), repoFile, false)).isAbsolute() ? "module:/classpath/var/M2_REPO/" + relativePath : "module:/classpath/lib/" + IdeUtils.toRelativeAndFixSeparator(this.config.getEclipseProjectDirectory(), repoFile, false));
            archiveName = "ear".equals(this.config.getPackaging()) && !"/".equals(deployPath) ? "../" + artifactPath.getName() : artifactPath.getName();
        }
        writer.startElement(ELT_DEPENDENT_MODULE);
        writer.addAttribute("archiveName", archiveName);
        writer.addAttribute(ATTR_DEPLOY_PATH, deployPath);
        writer.addAttribute(ATTR_HANDLE, handle);
        if (dependentObject != null && this.config.getWtpVersion() >= 2.0f) {
            writer.startElement(ELT_DEPENDENCY_OBJECT);
            writer.writeText(dependentObject + System.identityHashCode(dep));
            writer.endElement();
        }
        writer.startElement(ELT_DEPENDENCY_TYPE);
        writer.writeText("uses");
        writer.endElement();
        writer.endElement();
    }

    protected void writeWarOrEarResources(XMLWriter writer, MavenProject project, ArtifactRepository localRepository) throws MojoExecutionException {
        String deployDir = IdeUtils.getPluginSetting(this.config.getProject(), "org.apache.maven.plugins:maven-ear-plugin", "defaultLibBundleDir", "/");
        if (project.getPackaging().equals("war")) {
            deployDir = "/WEB-INF/lib";
        }
        for (int j = 0; j < this.config.getDeps().length; ++j) {
            IdeDependency dep = this.config.getDeps()[j];
            String type = dep.getType();
            if (dep.isTestDependency() || dep.isProvided() || dep.isSystemScopedOutsideProject(project) || !"jar".equals(type) && !"ejb".equals(type) && !"ejb-client".equals(type) && !"war".equals(type)) continue;
            this.addDependency(writer, dep, localRepository, this.config.getProject().getBasedir(), deployDir);
        }
    }
}

