/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;

public abstract class AbstractHelpMojo
extends AbstractMojo {
    protected static final int LINE_LENGTH = 79;
    protected static final String LS = System.getProperty("line.separator");
    @Component
    protected ProjectBuilder projectBuilder;
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(property="output")
    protected File output;

    protected static void writeFile(File output, StringBuilder content) throws IOException {
        AbstractHelpMojo.writeFile(output, content.toString());
    }

    protected static void writeFile(File output, String content) throws IOException {
        if (output == null) {
            return;
        }
        output.getParentFile().mkdirs();
        try (Writer out = WriterFactory.newPlatformWriter((File)output);){
            out.write(content);
        }
    }

    protected Artifact getAetherArtifact(String artifactString, String type) throws MojoExecutionException {
        String version;
        String artifactId;
        String groupId;
        if (StringUtils.isEmpty((String)artifactString)) {
            throw new IllegalArgumentException("artifact parameter could not be empty");
        }
        String[] artifactParts = artifactString.split(":");
        switch (artifactParts.length) {
            case 2: {
                groupId = artifactParts[0];
                artifactId = artifactParts[1];
                version = "LATEST";
                break;
            }
            case 3: {
                groupId = artifactParts[0];
                artifactId = artifactParts[1];
                version = artifactParts[2];
                break;
            }
            default: {
                throw new MojoExecutionException("The artifact parameter '" + artifactString + "' should be conform to: 'groupId:artifactId[:version]'.");
            }
        }
        return new DefaultArtifact(groupId, artifactId, type, version);
    }

    protected MavenProject getMavenProject(String artifactString) throws MojoExecutionException {
        try {
            DefaultProjectBuildingRequest pbr = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            pbr.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
            pbr.setPluginArtifactRepositories(this.project.getPluginArtifactRepositories());
            pbr.setProject(null);
            pbr.setValidationLevel(0);
            pbr.setResolveDependencies(true);
            Artifact artifact = this.resolveArtifact(this.getAetherArtifact(artifactString, "pom")).getArtifact();
            return this.projectBuilder.build(artifact.getFile(), (ProjectBuildingRequest)pbr).getProject();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to get the POM for the artifact '" + artifactString + "'. Verify the artifact parameter.", e);
        }
    }

    protected ArtifactResult resolveArtifact(Artifact artifact) throws RepositoryException {
        RepositorySystemSession repositorySession = this.session.getRepositorySession();
        ArtifactDescriptorResult artifactDescriptor = this.repositorySystem.readArtifactDescriptor(repositorySession, new ArtifactDescriptorRequest(artifact, this.project.getRemoteProjectRepositories(), null));
        return this.repositorySystem.resolveArtifact(repositorySession, new ArtifactRequest(artifactDescriptor.getArtifact(), this.project.getRemoteProjectRepositories(), null));
    }
}

