/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.install;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.install.DualDigester;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.utils.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInstallMojo
extends AbstractMojo {
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected ArtifactInstaller installer;
    @Parameter(property="localRepository", required=true, readonly=true)
    protected ArtifactRepository localRepository;
    @Parameter(property="createChecksum", defaultValue="false")
    protected boolean createChecksum;
    @Parameter(property="updateReleaseInfo", defaultValue="false")
    protected boolean updateReleaseInfo;
    protected final DualDigester digester = new DualDigester();

    protected File getLocalRepoFile(Artifact artifact) {
        String path = this.localRepository.pathOf(artifact);
        return new File(this.localRepository.getBasedir(), path);
    }

    protected File getLocalRepoFile(ArtifactMetadata metadata) {
        String path = this.localRepository.pathOfLocalRepositoryMetadata(metadata, this.localRepository);
        return new File(this.localRepository.getBasedir(), path);
    }

    protected void installChecksums(Artifact artifact) throws MojoExecutionException {
        if (!this.createChecksum) {
            return;
        }
        File artifactFile = this.getLocalRepoFile(artifact);
        this.installChecksums(artifactFile);
    }

    protected void addMetaDataFilesForArtifact(Artifact artifact, Collection<File> targetMetadataFiles) {
        if (!this.createChecksum) {
            return;
        }
        Collection metadatas = artifact.getMetadataList();
        if (metadatas != null) {
            for (ArtifactMetadata metadata : metadatas) {
                File metadataFile = this.getLocalRepoFile(metadata);
                targetMetadataFiles.add(metadataFile);
            }
        }
    }

    protected void installChecksums(Collection<File> metadataFiles) throws MojoExecutionException {
        for (File metadataFile : metadataFiles) {
            this.installChecksums(metadataFile);
        }
    }

    private void installChecksums(File installedFile) throws MojoExecutionException {
        boolean signatureFile = installedFile.getName().endsWith(".asc");
        if (installedFile.isFile() && !signatureFile) {
            this.getLog().debug((CharSequence)("Calculating checksums for " + installedFile));
            this.digester.calculate(installedFile);
            this.installChecksum(installedFile, ".md5", this.digester.getMd5());
            this.installChecksum(installedFile, ".sha1", this.digester.getSha1());
        }
    }

    private void installChecksum(File installedFile, String ext, String checksum) throws MojoExecutionException {
        File checksumFile = new File(installedFile.getAbsolutePath() + ext);
        this.getLog().debug((CharSequence)("Installing checksum to " + checksumFile));
        try {
            checksumFile.getParentFile().mkdirs();
            FileUtils.fileWrite((String)checksumFile.getAbsolutePath(), (String)"UTF-8", (String)checksum);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to install checksum to " + checksumFile, (Exception)e);
        }
    }
}

