/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.accurev.util;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QuotedPropertyParser {
    private QuotedPropertyParser() {
    }

    public static Map<String, String> parse(CharSequence seq) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        QuotedPropertyParser.parse(seq, hashMap);
        return hashMap;
    }

    public static void parse(CharSequence string, Map<? super String, ? super String> propertyMap) {
        int i;
        QuotedParseState state = QuotedParseState.KEY;
        char quote = '\u0000';
        StringBuffer buffer = new StringBuffer();
        String propertyKey = "";
        int pos = 0;
        block13: for (i = 0; i < string.length(); ++i) {
            char current = string.charAt(i);
            switch (state) {
                case KEY: {
                    switch (current) {
                        case '\"': 
                        case '\'': {
                            quote = current;
                            state = QuotedParseState.IN_QUOTED_KEY;
                            if (i >= pos) {
                                buffer.append(string.subSequence(pos, i));
                            }
                            pos = i + 1;
                            break;
                        }
                        case '=': {
                            if (i >= pos) {
                                buffer.append(string.subSequence(pos, i));
                            }
                            propertyKey = buffer.toString();
                            buffer = new StringBuffer();
                            state = QuotedParseState.VALUE;
                            pos = i + 1;
                        }
                    }
                    continue block13;
                }
                case VALUE: {
                    switch (current) {
                        case '\"': 
                        case '\'': {
                            quote = current;
                            state = QuotedParseState.IN_QUOTED_VALUE;
                            if (i >= pos) {
                                buffer.append(string.subSequence(pos, i));
                            }
                            pos = i + 1;
                            continue block13;
                        }
                        case '&': {
                            if (i >= pos) {
                                buffer.append(string.subSequence(pos, i));
                            }
                            propertyMap.put(propertyKey, buffer.toString());
                            pos = i + 1;
                            buffer = new StringBuffer();
                            state = QuotedParseState.KEY;
                            continue block13;
                        }
                    }
                    continue block13;
                }
                case IN_QUOTED_KEY: 
                case IN_QUOTED_VALUE: {
                    if (current != quote) continue block13;
                    QuotedParseState quotedParseState = state = state == QuotedParseState.IN_QUOTED_KEY ? QuotedParseState.KEY : QuotedParseState.VALUE;
                    if (i >= pos) {
                        buffer.append(string.subSequence(pos, i));
                    }
                    pos = i + 1;
                    continue block13;
                }
            }
        }
        if (state == QuotedParseState.VALUE) {
            if (i >= pos) {
                buffer.append(string.subSequence(pos, i));
            }
            propertyMap.put(propertyKey, buffer.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QuotedParseState {
        KEY,
        IN_QUOTED_KEY,
        IN_QUOTED_VALUE,
        VALUE;

    }
}

