/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.surefire.ConfigurableProviderInfo;
import org.apache.maven.plugin.surefire.ProviderInfo;
import org.apache.maven.plugin.surefire.booterclient.ProviderDetector;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.util.NestedRuntimeException;

public class ProviderList {
    private final ProviderInfo[] wellKnownProviders;
    private final ConfigurableProviderInfo dynamicProvider;

    public ProviderList(ProviderInfo[] wellKnownProviders, ConfigurableProviderInfo dynamicProviderInfo) {
        this.wellKnownProviders = wellKnownProviders;
        this.dynamicProvider = dynamicProviderInfo;
    }

    public List resolve(Log log) {
        ArrayList<ProviderInfo> providersToRun = new ArrayList<ProviderInfo>();
        Set manuallyConfiguredProviders = this.getManuallyConfiguredProviders();
        if (manuallyConfiguredProviders.size() > 0) {
            Iterator iter = manuallyConfiguredProviders.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                ProviderInfo wellKnown = this.findByName(name);
                ProviderInfo providerToAdd = wellKnown != null ? wellKnown : this.dynamicProvider.instantiate(name);
                log.info((CharSequence)("Using configured provider " + providerToAdd.getProviderName()));
                providersToRun.add(providerToAdd);
            }
            return providersToRun;
        }
        return this.autoDetectOneProvider();
    }

    private List autoDetectOneProvider() {
        ArrayList<ProviderInfo> providersToRun = new ArrayList<ProviderInfo>();
        for (int i = 0; i < this.wellKnownProviders.length; ++i) {
            if (!this.wellKnownProviders[i].isApplicable()) continue;
            providersToRun.add(this.wellKnownProviders[i]);
            return providersToRun;
        }
        return providersToRun;
    }

    private Set getManuallyConfiguredProviders() {
        try {
            return ProviderDetector.getServiceNames(SurefireProvider.class, Thread.currentThread().getContextClassLoader());
        }
        catch (IOException e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    private ProviderInfo findByName(String providerClassName) {
        for (int i = 0; i < this.wellKnownProviders.length; ++i) {
            ProviderInfo wellKnownProvider = this.wellKnownProviders[i];
            if (!wellKnownProvider.getProviderName().equals(providerClassName)) continue;
            return wellKnownProvider;
        }
        return null;
    }
}

