/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import org.apache.openjpa.persistence.OpenJPAEnum;

public enum FetchMode implements OpenJPAEnum<FetchMode>
{
    NONE(0, "none"),
    JOIN(1, "join"),
    PARALLEL(2, "parallel");

    private final int eagerFetchConstant;
    private final String[] _names;

    private FetchMode(int value, String ... names) {
        this.eagerFetchConstant = value;
        this._names = names;
    }

    public int toKernelConstant() {
        return this.eagerFetchConstant;
    }

    static FetchMode fromKernelConstant(int kernelConstant) {
        switch (kernelConstant) {
            case 0: {
                return NONE;
            }
            case 1: {
                return JOIN;
            }
            case 2: {
                return PARALLEL;
            }
        }
        throw new IllegalArgumentException(kernelConstant + "");
    }

    public int convertToKernelConstant(String s) {
        return FetchMode.toKernelConstantFromString(s);
    }

    public int convertToKernelConstant(int i) {
        if (i == -99) {
            return i;
        }
        for (FetchMode mode : FetchMode.values()) {
            if (mode.eagerFetchConstant != i) continue;
            return i;
        }
        throw new IllegalArgumentException(i + " is invalid value for FetchMode");
    }

    public static int toKernelConstantFromString(String s) {
        for (FetchMode level : FetchMode.values()) {
            for (String name : level._names) {
                if (!name.equalsIgnoreCase(s) && !String.valueOf(level.toKernelConstant()).equals(s)) continue;
                return level.toKernelConstant();
            }
        }
        throw new IllegalArgumentException(s + " is not a valid name for " + FetchMode.class.getName());
    }
}

