/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.web.config;

import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.spring.web.config.ShiroFilterChainDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class AbstractShiroWebFilterConfiguration {
    @Autowired
    protected SecurityManager securityManager;
    @Autowired
    protected ShiroFilterChainDefinition shiroFilterChainDefinition;
    @Value(value="#{ @environment['shiro.loginUrl'] ?: '/login.jsp' }")
    protected String loginUrl;
    @Value(value="#{ @environment['shiro.successUrl'] ?: '/' }")
    protected String successUrl;
    @Value(value="#{ @environment['shiro.unauthorizedUrl'] ?: null }")
    protected String unauthorizedUrl;

    protected ShiroFilterFactoryBean shiroFilterFactoryBean() {
        ShiroFilterFactoryBean filterFactoryBean = new ShiroFilterFactoryBean();
        filterFactoryBean.setLoginUrl(this.loginUrl);
        filterFactoryBean.setSuccessUrl(this.successUrl);
        filterFactoryBean.setUnauthorizedUrl(this.unauthorizedUrl);
        filterFactoryBean.setSecurityManager(this.securityManager);
        filterFactoryBean.setFilterChainDefinitionMap(this.shiroFilterChainDefinition.getFilterChainMap());
        return filterFactoryBean;
    }
}

