/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.array;

import org.apache.spark.unsafe.Platform;

public class ByteArrayMethods {
    private ByteArrayMethods() {
    }

    public static long nextPowerOf2(long num) {
        long highBit = Long.highestOneBit(num);
        return highBit == num ? num : highBit << 1;
    }

    public static int roundNumberOfBytesToNearestWord(int numBytes) {
        int remainder = numBytes & 7;
        if (remainder == 0) {
            return numBytes;
        }
        return numBytes + (8 - remainder);
    }

    public static boolean arrayEquals(Object leftBase, long leftOffset, Object rightBase, long rightOffset, long length) {
        int i = 0;
        while ((long)i <= length - 8L) {
            if (Platform.getLong(leftBase, leftOffset + (long)i) != Platform.getLong(rightBase, rightOffset + (long)i)) {
                return false;
            }
            i += 8;
        }
        while ((long)i < length) {
            if (Platform.getByte(leftBase, leftOffset + (long)i) != Platform.getByte(rightBase, rightOffset + (long)i)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

