/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.AlphabetMapper;
import org.bouncycastle.util.Integers;

public class BasicAlphabetMapper
implements AlphabetMapper {
    private Map indexMap = new HashMap();
    private Map charMap = new HashMap();

    public BasicAlphabetMapper(String string) {
        this(string.toCharArray());
    }

    public BasicAlphabetMapper(char[] cArray) {
        for (int i = 0; i != cArray.length; ++i) {
            if (this.indexMap.containsKey(new Character(cArray[i]))) {
                throw new IllegalArgumentException("duplicate key detected in alphabet: " + cArray[i]);
            }
            this.indexMap.put(new Character(cArray[i]), Integers.valueOf(i));
            this.charMap.put(Integers.valueOf(i), new Character(cArray[i]));
        }
    }

    public int getRadix() {
        return this.indexMap.size();
    }

    public byte[] convertToIndexes(char[] cArray) {
        byte[] byArray;
        if (this.indexMap.size() <= 256) {
            byArray = new byte[cArray.length];
            for (int i = 0; i != cArray.length; ++i) {
                byArray[i] = ((Integer)this.indexMap.get(new Character(cArray[i]))).byteValue();
            }
        } else {
            byArray = new byte[cArray.length * 2];
            for (int i = 0; i != cArray.length; ++i) {
                int n = (Integer)this.indexMap.get(new Character(cArray[i]));
                byArray[i * 2] = (byte)(n >> 8 & 0xFF);
                byArray[i * 2 + 1] = (byte)(n & 0xFF);
            }
        }
        return byArray;
    }

    public char[] convertToChars(byte[] byArray) {
        char[] cArray;
        if (this.charMap.size() <= 256) {
            cArray = new char[byArray.length];
            for (int i = 0; i != byArray.length; ++i) {
                cArray[i] = ((Character)this.charMap.get(Integers.valueOf(byArray[i] & 0xFF))).charValue();
            }
        } else {
            if ((byArray.length & 1) != 0) {
                throw new IllegalArgumentException("two byte radix and input string odd length");
            }
            cArray = new char[byArray.length / 2];
            for (int i = 0; i != byArray.length; i += 2) {
                cArray[i / 2] = ((Character)this.charMap.get(Integers.valueOf(byArray[i] << 8 & 0xFF00 | byArray[i + 1] & 0xFF))).charValue();
            }
        }
        return cArray;
    }
}

