/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.value;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.qual.BoolVal;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.DoubleVal;
import org.checkerframework.common.value.qual.IntVal;
import org.checkerframework.common.value.qual.StringVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.common.value.util.NumberMath;
import org.checkerframework.common.value.util.NumberUtils;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.BitwiseAndNode;
import org.checkerframework.dataflow.cfg.node.BitwiseComplementNode;
import org.checkerframework.dataflow.cfg.node.BitwiseOrNode;
import org.checkerframework.dataflow.cfg.node.BitwiseXorNode;
import org.checkerframework.dataflow.cfg.node.ConditionalAndNode;
import org.checkerframework.dataflow.cfg.node.ConditionalNotNode;
import org.checkerframework.dataflow.cfg.node.ConditionalOrNode;
import org.checkerframework.dataflow.cfg.node.EqualToNode;
import org.checkerframework.dataflow.cfg.node.FloatingDivisionNode;
import org.checkerframework.dataflow.cfg.node.FloatingRemainderNode;
import org.checkerframework.dataflow.cfg.node.GreaterThanNode;
import org.checkerframework.dataflow.cfg.node.GreaterThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.IntegerDivisionNode;
import org.checkerframework.dataflow.cfg.node.IntegerRemainderNode;
import org.checkerframework.dataflow.cfg.node.LeftShiftNode;
import org.checkerframework.dataflow.cfg.node.LessThanNode;
import org.checkerframework.dataflow.cfg.node.LessThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NotEqualNode;
import org.checkerframework.dataflow.cfg.node.NumericalAdditionNode;
import org.checkerframework.dataflow.cfg.node.NumericalMinusNode;
import org.checkerframework.dataflow.cfg.node.NumericalMultiplicationNode;
import org.checkerframework.dataflow.cfg.node.NumericalPlusNode;
import org.checkerframework.dataflow.cfg.node.NumericalSubtractionNode;
import org.checkerframework.dataflow.cfg.node.SignedRightShiftNode;
import org.checkerframework.dataflow.cfg.node.StringConcatenateNode;
import org.checkerframework.dataflow.cfg.node.StringConversionNode;
import org.checkerframework.dataflow.cfg.node.UnsignedRightShiftNode;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TypesUtils;

public class ValueTransfer
extends CFTransfer {
    AnnotatedTypeFactory atypefactory;

    public ValueTransfer(CFAbstractAnalysis<CFValue, CFStore, CFTransfer> analysis) {
        super(analysis);
        this.atypefactory = analysis.getTypeFactory();
    }

    private List<String> getStringValues(Node subNode, TransferInput<CFValue, CFStore> p) {
        List<Serializable> values;
        CFValue value = p.getValueOfSubNode(subNode);
        AnnotationMirror numberAnno = value.getType().getAnnotation(StringVal.class);
        if (numberAnno != null) {
            return AnnotationUtils.getElementValueArray(numberAnno, "value", String.class, true);
        }
        numberAnno = value.getType().getAnnotation(UnknownVal.class);
        if (numberAnno != null) {
            return new ArrayList<String>();
        }
        numberAnno = value.getType().getAnnotation(BottomVal.class);
        if (numberAnno != null) {
            return Collections.singletonList("null");
        }
        numberAnno = value.getType().getAnnotation(BoolVal.class);
        if (numberAnno != null) {
            values = this.getBooleanValues(subNode, p);
        } else if (subNode.getType().getKind() == TypeKind.CHAR) {
            values = this.getCharValues(subNode, p);
        } else {
            if (subNode instanceof StringConversionNode) {
                return this.getStringValues(((StringConversionNode)subNode).getOperand(), p);
            }
            values = this.getNumericalValues(subNode, p);
        }
        ArrayList<String> stringValues = new ArrayList<String>();
        for (Comparable<Boolean> comparable : values) {
            stringValues.add(comparable.toString());
        }
        return stringValues;
    }

    private List<Boolean> getBooleanValues(Node subNode, TransferInput<CFValue, CFStore> p) {
        CFValue value = p.getValueOfSubNode(subNode);
        AnnotationMirror intAnno = value.getType().getAnnotation(BoolVal.class);
        return ValueAnnotatedTypeFactory.getBooleanValues(intAnno);
    }

    private List<Character> getCharValues(Node subNode, TransferInput<CFValue, CFStore> p) {
        CFValue value = p.getValueOfSubNode(subNode);
        AnnotationMirror intAnno = value.getType().getAnnotation(IntVal.class);
        return ValueAnnotatedTypeFactory.getCharValues(intAnno);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<? extends Number> getNumericalValues(Node subNode, TransferInput<CFValue, CFStore> p) {
        void var5_7;
        CFValue value = p.getValueOfSubNode(subNode);
        AnnotationMirror numberAnno = value.getType().getAnnotation(IntVal.class);
        if (numberAnno == null) {
            numberAnno = value.getType().getAnnotation(DoubleVal.class);
            if (numberAnno == null) return new ArrayList();
            List<Double> list = AnnotationUtils.getElementValueArray(numberAnno, "value", Double.class, true);
            return NumberUtils.castNumbers(subNode.getType(), (List<? extends Number>)var5_7);
        } else {
            List<Long> list = AnnotationUtils.getElementValueArray(numberAnno, "value", Long.class, true);
        }
        return NumberUtils.castNumbers(subNode.getType(), (List<? extends Number>)var5_7);
    }

    private AnnotationMirror createStringValAnnotationMirror(List<String> values) {
        if (values.isEmpty()) {
            return ((ValueAnnotatedTypeFactory)this.atypefactory).UNKNOWNVAL;
        }
        return ((ValueAnnotatedTypeFactory)this.atypefactory).createStringAnnotation(values);
    }

    private AnnotationMirror createNumberAnnotationMirror(List<Number> values) {
        if (values.isEmpty()) {
            return ((ValueAnnotatedTypeFactory)this.atypefactory).UNKNOWNVAL;
        }
        Number first = values.get(0);
        if (first instanceof Integer || first instanceof Short || first instanceof Long) {
            ArrayList<Long> intValues = new ArrayList<Long>();
            for (Number number : values) {
                intValues.add(number.longValue());
            }
            return ((ValueAnnotatedTypeFactory)this.atypefactory).createIntValAnnotation(intValues);
        }
        if (first instanceof Double || first instanceof Float) {
            ArrayList<Double> intValues = new ArrayList<Double>();
            for (Number number : values) {
                intValues.add(number.doubleValue());
            }
            return ((ValueAnnotatedTypeFactory)this.atypefactory).createDoubleValAnnotation(intValues);
        }
        throw new UnsupportedOperationException();
    }

    private AnnotationMirror createBooleanAnnotationMirror(List<Boolean> values) {
        if (values.isEmpty()) {
            return ((ValueAnnotatedTypeFactory)this.atypefactory).UNKNOWNVAL;
        }
        return ((ValueAnnotatedTypeFactory)this.atypefactory).createBooleanAnnotation(values);
    }

    private TransferResult<CFValue, CFStore> createNewResult(TransferResult<CFValue, CFStore> result, List<Number> resultValues) {
        AnnotationMirror stringVal = this.createNumberAnnotationMirror(resultValues);
        CFValue newResultValue = (CFValue)this.analysis.createSingleAnnotationValue(stringVal, result.getResultValue().getType().getUnderlyingType());
        return new RegularTransferResult<CFValue, CFStore>(newResultValue, result.getRegularStore());
    }

    private TransferResult<CFValue, CFStore> createNewResultBoolean(TransferResult<CFValue, CFStore> result, List<Boolean> resultValues) {
        AnnotationMirror stringVal = this.createBooleanAnnotationMirror(resultValues);
        CFValue newResultValue = (CFValue)this.analysis.createSingleAnnotationValue(stringVal, result.getResultValue().getType().getUnderlyingType());
        return new RegularTransferResult<CFValue, CFStore>(newResultValue, result.getRegularStore());
    }

    @Override
    public TransferResult<CFValue, CFStore> visitStringConcatenate(StringConcatenateNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult result = (TransferResult)super.visitStringConcatenate(n, p);
        List<String> lefts = this.getStringValues(n.getLeftOperand(), p);
        List<String> rights = this.getStringValues(n.getRightOperand(), p);
        ArrayList<String> concat = new ArrayList<String>();
        for (String left : lefts) {
            for (String right : rights) {
                concat.add(left + right);
            }
        }
        AnnotationMirror stringVal = this.createStringValAnnotationMirror(concat);
        CFValue newResultValue = (CFValue)this.analysis.createSingleAnnotationValue(stringVal, ((CFValue)result.getResultValue()).getType().getUnderlyingType());
        return new RegularTransferResult<CFValue, CFStore>(newResultValue, (CFStore)result.getRegularStore());
    }

    private List<Number> calcutateNumericalBinaryOp(Node leftNode, Node rightNode, NumbericalBinaryOps op, TransferInput<CFValue, CFStore> p) {
        List<? extends Number> lefts = this.getNumericalValues(leftNode, p);
        List<? extends Number> rights = this.getNumericalValues(rightNode, p);
        ArrayList<Number> resultValues = new ArrayList<Number>();
        for (Number number : lefts) {
            NumberMath<?> nmLeft = NumberMath.getNumberMath(number);
            block14: for (Number number2 : rights) {
                switch (op) {
                    case ADDTION: {
                        resultValues.add(nmLeft.plus(number2));
                        continue block14;
                    }
                    case DIVISION: {
                        resultValues.add(nmLeft.divide(number2));
                        continue block14;
                    }
                    case MULPLICATION: {
                        resultValues.add(nmLeft.times(number2));
                        continue block14;
                    }
                    case REMAINDER: {
                        resultValues.add(nmLeft.remainder(number2));
                        continue block14;
                    }
                    case SUBTRACTION: {
                        resultValues.add(nmLeft.minus(number2));
                        continue block14;
                    }
                    case SHIFT_LEFT: {
                        resultValues.add(nmLeft.shiftLeft(number2));
                        continue block14;
                    }
                    case SIGNED_SHIFT_RIGHT: {
                        resultValues.add(nmLeft.signedSiftRight(number2));
                        continue block14;
                    }
                    case UNSIGNED_SHIFT_RIGHT: {
                        resultValues.add(nmLeft.unsignedSiftRight(number2));
                        continue block14;
                    }
                    case BITWISE_AND: {
                        resultValues.add(nmLeft.bitwiseAnd(number2));
                        continue block14;
                    }
                    case BITWISE_OR: {
                        resultValues.add(nmLeft.bitwiseOr(number2));
                        continue block14;
                    }
                    case BITWISE_XOR: {
                        resultValues.add(nmLeft.bitwiseXor(number2));
                        continue block14;
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
        return resultValues;
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalAddition(NumericalAdditionNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitNumericalAddition(n, p);
        List<Number> resultValues = this.calcutateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumbericalBinaryOps.ADDTION, p);
        return this.createNewResult(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalSubtraction(NumericalSubtractionNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitNumericalSubtraction(n, p);
        List<Number> resultValues = this.calcutateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumbericalBinaryOps.SUBTRACTION, p);
        return this.createNewResult(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalMultiplication(NumericalMultiplicationNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitNumericalMultiplication(n, p);
        List<Number> resultValues = this.calcutateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumbericalBinaryOps.MULPLICATION, p);
        return this.createNewResult(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitIntegerDivision(IntegerDivisionNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitIntegerDivision(n, p);
        List<Number> resultValues = this.calcutateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumbericalBinaryOps.DIVISION, p);
        return this.createNewResult(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitFloatingDivision(FloatingDivisionNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitFloatingDivision(n, p);
        List<Number> resultValues = this.calcutateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumbericalBinaryOps.DIVISION, p);
        return this.createNewResult(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitIntegerRemainder(IntegerRemainderNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitIntegerRemainder(n, p);
        List<Number> resultValues = this.calcutateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumbericalBinaryOps.REMAINDER, p);
        return this.createNewResult(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitFloatingRemainder(FloatingRemainderNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitFloatingRemainder(n, p);
        List<Number> resultValues = this.calcutateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumbericalBinaryOps.REMAINDER, p);
        return this.createNewResult(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitLeftShift(LeftShiftNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitLeftShift(n, p);
        List<Number> resultValues = this.calcutateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumbericalBinaryOps.SHIFT_LEFT, p);
        return this.createNewResult(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitSignedRightShift(SignedRightShiftNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitSignedRightShift(n, p);
        List<Number> resultValues = this.calcutateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumbericalBinaryOps.SIGNED_SHIFT_RIGHT, p);
        return this.createNewResult(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitUnsignedRightShift(UnsignedRightShiftNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitUnsignedRightShift(n, p);
        List<Number> resultValues = this.calcutateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumbericalBinaryOps.UNSIGNED_SHIFT_RIGHT, p);
        return this.createNewResult(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitBitwiseAnd(BitwiseAndNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitBitwiseAnd(n, p);
        List<Number> resultValues = this.calcutateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumbericalBinaryOps.BITWISE_AND, p);
        return this.createNewResult(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitBitwiseOr(BitwiseOrNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitBitwiseOr(n, p);
        List<Number> resultValues = this.calcutateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumbericalBinaryOps.BITWISE_OR, p);
        return this.createNewResult(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitBitwiseXor(BitwiseXorNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitBitwiseXor(n, p);
        List<Number> resultValues = this.calcutateNumericalBinaryOp(n.getLeftOperand(), n.getRightOperand(), NumbericalBinaryOps.BITWISE_XOR, p);
        return this.createNewResult(transferResult, resultValues);
    }

    private List<Number> calcutateNumericalUnaryOp(Node operand, NumbericalUnaryOps op, TransferInput<CFValue, CFStore> p) {
        List<? extends Number> lefts = this.getNumericalValues(operand, p);
        ArrayList<Number> resultValues = new ArrayList<Number>();
        block5: for (Number number : lefts) {
            NumberMath<?> nmLeft = NumberMath.getNumberMath(number);
            switch (op) {
                case PLUS: {
                    resultValues.add(nmLeft.unaryPlus());
                    continue block5;
                }
                case MINUS: {
                    resultValues.add(nmLeft.unaryMinus());
                    continue block5;
                }
                case BITWISE_COMPLEMENT: {
                    resultValues.add(nmLeft.bitwiseComplement());
                    continue block5;
                }
            }
            throw new UnsupportedOperationException();
        }
        return resultValues;
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalMinus(NumericalMinusNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitNumericalMinus(n, p);
        List<Number> resultValues = this.calcutateNumericalUnaryOp(n.getOperand(), NumbericalUnaryOps.MINUS, p);
        return this.createNewResult(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalPlus(NumericalPlusNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitNumericalPlus(n, p);
        List<Number> resultValues = this.calcutateNumericalUnaryOp(n.getOperand(), NumbericalUnaryOps.PLUS, p);
        return this.createNewResult(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitBitwiseComplement(BitwiseComplementNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitBitwiseComplement(n, p);
        List<Number> resultValues = this.calcutateNumericalUnaryOp(n.getOperand(), NumbericalUnaryOps.BITWISE_COMPLEMENT, p);
        return this.createNewResult(transferResult, resultValues);
    }

    private List<Boolean> calcutateBinaryComparison(Node leftNode, Node rightNode, ComparisonOperators op, TransferInput<CFValue, CFStore> p) {
        List<? extends Number> lefts = this.getNumericalValues(leftNode, p);
        List<? extends Number> rights = this.getNumericalValues(rightNode, p);
        ArrayList<Boolean> resultValues = new ArrayList<Boolean>();
        for (Number number : lefts) {
            NumberMath<?> nmLeft = NumberMath.getNumberMath(number);
            block9: for (Number number2 : rights) {
                switch (op) {
                    case EQUAL: {
                        resultValues.add(nmLeft.equalTo(number2));
                        continue block9;
                    }
                    case GREATER_THAN: {
                        resultValues.add(nmLeft.greaterThan(number2));
                        continue block9;
                    }
                    case GREATER_THAN_EQ: {
                        resultValues.add(nmLeft.greaterThanEq(number2));
                        continue block9;
                    }
                    case LESS_THAN: {
                        resultValues.add(nmLeft.lessThan(number2));
                        continue block9;
                    }
                    case LESS_THAN_EQ: {
                        resultValues.add(nmLeft.lessThanEq(number2));
                        continue block9;
                    }
                    case NOT_EQUAL: {
                        resultValues.add(nmLeft.notEqualTo(number2));
                        continue block9;
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
        return resultValues;
    }

    @Override
    public TransferResult<CFValue, CFStore> visitLessThan(LessThanNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitLessThan(n, p);
        List<Boolean> resultValues = this.calcutateBinaryComparison(n.getLeftOperand(), n.getRightOperand(), ComparisonOperators.LESS_THAN, p);
        return this.createNewResultBoolean(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitLessThanOrEqual(LessThanOrEqualNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitLessThanOrEqual(n, p);
        List<Boolean> resultValues = this.calcutateBinaryComparison(n.getLeftOperand(), n.getRightOperand(), ComparisonOperators.LESS_THAN_EQ, p);
        return this.createNewResultBoolean(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitGreaterThan(GreaterThanNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitGreaterThan(n, p);
        List<Boolean> resultValues = this.calcutateBinaryComparison(n.getLeftOperand(), n.getRightOperand(), ComparisonOperators.GREATER_THAN, p);
        return this.createNewResultBoolean(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitGreaterThanOrEqual(GreaterThanOrEqualNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitGreaterThanOrEqual(n, p);
        List<Boolean> resultValues = this.calcutateBinaryComparison(n.getLeftOperand(), n.getRightOperand(), ComparisonOperators.GREATER_THAN_EQ, p);
        return this.createNewResultBoolean(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitEqualTo(EqualToNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<CFValue, CFStore> transferResult = super.visitEqualTo(n, p);
        if (TypesUtils.isPrimitive(n.getLeftOperand().getType()) || TypesUtils.isPrimitive(n.getRightOperand().getType())) {
            List<Boolean> resultValues = this.calcutateBinaryComparison(n.getLeftOperand(), n.getRightOperand(), ComparisonOperators.EQUAL, p);
            return this.createNewResultBoolean(transferResult, resultValues);
        }
        return super.visitEqualTo(n, p);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNotEqual(NotEqualNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<CFValue, CFStore> transferResult = super.visitNotEqual(n, p);
        if (TypesUtils.isPrimitive(n.getLeftOperand().getType()) || TypesUtils.isPrimitive(n.getRightOperand().getType())) {
            List<Boolean> resultValues = this.calcutateBinaryComparison(n.getLeftOperand(), n.getRightOperand(), ComparisonOperators.NOT_EQUAL, p);
            return this.createNewResultBoolean(transferResult, resultValues);
        }
        return super.visitNotEqual(n, p);
    }

    private List<Boolean> calcutateCondtionalOperator(Node leftNode, Node rightNode, ConditionalOperators op, TransferInput<CFValue, CFStore> p) {
        List<Boolean> lefts = this.getBooleanValues(leftNode, p);
        ArrayList<Boolean> resultValues = new ArrayList<Boolean>();
        List<Object> rights = new ArrayList();
        if (rightNode != null) {
            rights = this.getBooleanValues(rightNode, p);
        }
        switch (op) {
            case NOT: {
                for (Boolean left : lefts) {
                    resultValues.add(left == false);
                }
                return resultValues;
            }
            case OR: {
                if (lefts.isEmpty() && rights.size() == 1 && ((Boolean)rights.get(0)).booleanValue()) {
                    return rights;
                }
                if (rights.isEmpty() && lefts.size() == 1 && lefts.get(0).booleanValue()) {
                    return lefts;
                }
                for (Boolean left : lefts) {
                    for (Boolean bl : rights) {
                        resultValues.add(left != false || bl != false);
                    }
                }
                return resultValues;
            }
            case AND: {
                if (lefts.isEmpty() && rights.size() == 1 && !((Boolean)rights.get(0)).booleanValue()) {
                    return rights;
                }
                if (rights.isEmpty() && lefts.size() == 1 && !lefts.get(0).booleanValue()) {
                    return lefts;
                }
                for (Boolean left : lefts) {
                    for (Boolean bl : rights) {
                        resultValues.add(left != false && bl != false);
                    }
                }
                return resultValues;
            }
        }
        return resultValues;
    }

    @Override
    public TransferResult<CFValue, CFStore> visitConditionalNot(ConditionalNotNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult<CFValue, CFStore> transferResult = super.visitConditionalNot(n, p);
        List<Boolean> resultValues = this.calcutateCondtionalOperator(n.getOperand(), null, ConditionalOperators.NOT, p);
        return this.createNewResultBoolean(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitConditionalAnd(ConditionalAndNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitConditionalAnd(n, p);
        List<Boolean> resultValues = this.calcutateCondtionalOperator(n.getLeftOperand(), n.getRightOperand(), ConditionalOperators.AND, p);
        return this.createNewResultBoolean(transferResult, resultValues);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitConditionalOr(ConditionalOrNode n, TransferInput<CFValue, CFStore> p) {
        TransferResult transferResult = (TransferResult)super.visitConditionalOr(n, p);
        List<Boolean> resultValues = this.calcutateCondtionalOperator(n.getLeftOperand(), n.getRightOperand(), ConditionalOperators.OR, p);
        return this.createNewResultBoolean(transferResult, resultValues);
    }

    static enum ConditionalOperators {
        NOT,
        OR,
        AND;

    }

    static enum ComparisonOperators {
        EQUAL,
        NOT_EQUAL,
        GREATER_THAN,
        GREATER_THAN_EQ,
        LESS_THAN,
        LESS_THAN_EQ;

    }

    static enum NumbericalUnaryOps {
        PLUS,
        MINUS,
        BITWISE_COMPLEMENT;

    }

    static enum NumbericalBinaryOps {
        ADDTION,
        SUBTRACTION,
        DIVISION,
        REMAINDER,
        MULPLICATION,
        SHIFT_LEFT,
        SIGNED_SHIFT_RIGHT,
        UNSIGNED_SHIFT_RIGHT,
        BITWISE_AND,
        BITWISE_OR,
        BITWISE_XOR;

    }
}

