/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.value;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import java.util.List;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.qual.ArrayLen;
import org.checkerframework.common.value.qual.BoolVal;
import org.checkerframework.common.value.qual.DoubleVal;
import org.checkerframework.common.value.qual.IntVal;
import org.checkerframework.common.value.qual.StringVal;
import org.checkerframework.framework.source.Result;

public class ValueVisitor
extends BaseTypeVisitor<ValueAnnotatedTypeFactory> {
    public ValueVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    protected ValueAnnotatedTypeFactory createTypeFactory() {
        return new ValueAnnotatedTypeFactory(this.checker);
    }

    @Override
    public Void visitAnnotation(AnnotationTree node, Void p) {
        int numArgs;
        AssignmentTree argument;
        List<? extends ExpressionTree> args = node.getArguments();
        if (args.isEmpty()) {
            return super.visitAnnotation(node, p);
        }
        Symbol element = TreeInfo.symbol((JCTree)node.getAnnotationType());
        if (!(((Object)element).toString().equals(ArrayLen.class.getName()) || ((Object)element).toString().equals(BoolVal.class.getName()) || ((Object)element).toString().equals(DoubleVal.class.getName()) || ((Object)element).toString().equals(IntVal.class.getName()) || ((Object)element).toString().equals(StringVal.class.getName()))) {
            return super.visitAnnotation(node, p);
        }
        if (node.getArguments().size() > 0 && node.getArguments().get(0).getKind() == Tree.Kind.ASSIGNMENT && (argument = (AssignmentTree)node.getArguments().get(0)).getExpression().getKind() == Tree.Kind.NEW_ARRAY && (numArgs = ((NewArrayTree)argument.getExpression()).getInitializers().size()) > 10) {
            this.checker.report(Result.warning("too.many.values.given", 10), node);
            return null;
        }
        return super.visitAnnotation(node, p);
    }

    @Override
    public Void visitTypeCast(TypeCastTree node, Void p) {
        if (node.getExpression().getKind() == Tree.Kind.NULL_LITERAL) {
            return null;
        }
        return super.visitTypeCast(node, p);
    }
}

