/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.visitor.EquivalentAtmComboScanner;
import org.checkerframework.javacutil.AnnotationUtils;

public class EqualityAtmComparer
extends EquivalentAtmComboScanner<Boolean, Void> {
    @Override
    protected String defaultErrorMessage(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, Void v) {
        throw new UnsupportedOperationException("Comparing two different subclasses of AnnotatedTypeMirror!\ntype1=" + type1 + "\n" + "type2=" + type2 + "\n");
    }

    protected boolean arePrimeAnnosEqual(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
        return AnnotationUtils.areSame(type1.getAnnotations(), type2.getAnnotations());
    }

    protected boolean compare(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
        if (type1 == null && type2 != null || type1 != null && type2 == null) {
            return false;
        }
        if (type1 == type2) {
            return true;
        }
        boolean sameUnderlyingType = type1.getUnderlyingType().equals(type2.getUnderlyingType());
        return sameUnderlyingType && this.arePrimeAnnosEqual(type1, type2);
    }

    @Override
    protected Boolean scanWithNull(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, Void aVoid) {
        return type1 == type2;
    }

    @Override
    protected Boolean scan(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, Void v) {
        return this.compare(type1, type2) && this.reduce(true, (Boolean)super.scan(type1, type2, v)) != false;
    }

    @Override
    protected Boolean reduce(Boolean r1, Boolean r2) {
        if (r1 == null) {
            return r2;
        }
        if (r2 == null) {
            return r1;
        }
        return r1 != false && r2 != false;
    }
}

