/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.poly;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.qualframework.base.QualifierHierarchy;
import org.checkerframework.qualframework.base.TypeAnnotator;
import org.checkerframework.qualframework.poly.QualParams;
import org.checkerframework.qualframework.poly.QualifierParameterAnnotationConverter;
import org.checkerframework.qualframework.poly.Wildcard;
import org.checkerframework.qualframework.util.ExtendedDeclaredType;
import org.checkerframework.qualframework.util.ExtendedExecutableType;
import org.checkerframework.qualframework.util.ExtendedTypeMirror;
import org.checkerframework.qualframework.util.QualifierContext;

public class QualifierParameterTypeAnnotator<Q>
extends TypeAnnotator<QualParams<Q>> {
    private QualifierHierarchy<Wildcard<Q>> containmentHierarchy;

    public QualifierParameterTypeAnnotator(QualifierContext<QualParams<Q>> qualContext, QualifierParameterAnnotationConverter<Q> annotationConverter, QualifierHierarchy<Wildcard<Q>> containmentHierarchy) {
        super(qualContext, annotationConverter, new QualParams());
        this.containmentHierarchy = containmentHierarchy;
    }

    public QualifierHierarchy<Wildcard<Q>> getContainmentHierarchy() {
        return this.containmentHierarchy;
    }

    @Override
    public QualifierParameterAnnotationConverter<Q> getAnnotationConverter() {
        return (QualifierParameterAnnotationConverter)super.getAnnotationConverter();
    }

    @Override
    protected QualParams<Q> getQualifier(ExtendedTypeMirror type) {
        Set<Object> names;
        QualParams result = (QualParams)super.getQualifier(type);
        switch (type.getKind()) {
            case DECLARED: {
                Element declElt = ((ExtendedDeclaredType)type).asElement();
                names = this.getAnnotationConverter().getDeclaredParameters(declElt, this.qualContext.getTypeFactory().getDeclAnnotations(declElt), this.qualContext.getTypeFactory().getDecoratedElement(declElt));
                break;
            }
            case EXECUTABLE: {
                ExecutableElement executableElt = ((ExtendedExecutableType)type).asElement();
                names = this.getAnnotationConverter().getDeclaredParameters(executableElt, this.qualContext.getTypeFactory().getDeclAnnotations(executableElt), this.qualContext.getTypeFactory().getDecoratedElement(executableElt));
                break;
            }
            case VOID: 
            case PACKAGE: 
            case NONE: 
            case TYPEVAR: 
            case ARRAY: {
                names = Collections.emptySet();
                break;
            }
            case INTERSECTION: 
            case UNION: 
            case NULL: 
            case WILDCARD: {
                names = Collections.emptySet();
                break;
            }
            default: {
                if (type.getKind().isPrimitive()) {
                    names = Collections.emptySet();
                    break;
                }
                throw new IllegalArgumentException("unexpected type kind: " + (Object)((Object)type.getKind()));
            }
        }
        if (names.isEmpty()) {
            return result;
        }
        HashMap newParams = new HashMap(result);
        for (String name : names) {
            if (newParams.containsKey(name)) continue;
            newParams.put(name, this.containmentHierarchy.getTop());
        }
        return new QualParams(newParams, result.getPrimary());
    }
}

