/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.poly.format;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.qualframework.poly.PolyQual;
import org.checkerframework.qualframework.poly.QualParams;
import org.checkerframework.qualframework.poly.Wildcard;
import org.checkerframework.qualframework.poly.format.QualParamsFormatter;

public class PrettyQualParamsFormatter<Q>
implements QualParamsFormatter<Q> {
    private final Set<?> invisibleQualifiers;

    public PrettyQualParamsFormatter(Set<?> invisibleQualifiers) {
        this.invisibleQualifiers = invisibleQualifiers;
    }

    @Override
    public String format(QualParams<Q> params) {
        return this.format(params, true, true);
    }

    @Override
    public String format(QualParams<Q> params, boolean printInvisible) {
        return this.format(params, true, printInvisible);
    }

    @Override
    public String format(QualParams<Q> params, boolean printPrimary, boolean printInvisible) {
        String primary;
        StringBuilder sb = new StringBuilder();
        if (printPrimary && params.getPrimary() != null && (primary = this.format(params.getPrimary(), printInvisible)) != null) {
            sb.append(primary);
        }
        if (params.size() > 0) {
            sb.append("\u300a");
            boolean first = true;
            for (Map.Entry<String, Wildcard<Q>> entry : params.entrySet()) {
                String value = "";
                if (entry.getValue() != null && (value = this.format(entry.getValue(), printInvisible)) == null) {
                    value = "";
                }
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(entry.getKey());
                sb.append("=");
                sb.append(value);
            }
            sb.append("\u300b");
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    @Override
    public String format(PolyQual<Q> polyQual, boolean printInvisible) {
        if (polyQual == null) {
            return null;
        }
        if (polyQual instanceof PolyQual.Combined) {
            PolyQual.Combined combined = (PolyQual.Combined)polyQual;
            ArrayList<String> formattedVars = new ArrayList<String>();
            for (PolyQual.QualVar var : combined.getVars()) {
                String formatted = this.format(var, printInvisible);
                if (formatted == null) continue;
                formattedVars.add(formatted);
            }
            String formatted = this.formatQual(combined.getGround(), printInvisible);
            if (formatted != null) {
                formattedVars.add(formatted);
            }
            if (formattedVars.size() == 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(combined.getOp());
            sb.append("(");
            boolean first = true;
            for (String formattedVar : formattedVars) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(formattedVar);
            }
            sb.append(")");
            return sb.toString();
        }
        if (polyQual instanceof PolyQual.GroundQual) {
            return this.formatQual(((PolyQual.GroundQual)polyQual).getQualifier(), printInvisible);
        }
        if (polyQual instanceof PolyQual.QualVar) {
            PolyQual.QualVar qualVar = (PolyQual.QualVar)polyQual;
            String lower = this.formatQual(qualVar.getLowerBound(), printInvisible);
            String upper = this.formatQual(qualVar.getUpperBound(), printInvisible);
            if (lower == null && upper == null) {
                return qualVar.getName();
            }
            lower = lower == null ? "" : lower;
            upper = upper == null ? "" : upper;
            return qualVar.getName() + " \u2208 [" + lower + ".." + upper + "])";
        }
        ErrorReporter.errorAbort("Unknown PolyQual Subclass: " + polyQual);
        return "";
    }

    @Override
    private String format(Wildcard<Q> wildcard, boolean printInvisible) {
        if (wildcard.isEmpty()) {
            return "\u00f8";
        }
        if (wildcard.getLowerBound().equals(wildcard.getUpperBound())) {
            return this.format(wildcard.getLowerBound(), printInvisible);
        }
        String upper = this.format(wildcard.getUpperBound(), printInvisible);
        String lower = this.format(wildcard.getLowerBound(), printInvisible);
        if (upper == null && lower == null) {
            return "?";
        }
        lower = lower == null ? "" : lower;
        upper = upper == null ? "" : upper;
        return "? \u2208 [" + lower + ".." + upper + "]";
    }

    private String formatQual(Q qual, boolean printInvisible) {
        if (printInvisible || !this.invisibleQualifiers.contains(qual)) {
            return "@" + qual.toString();
        }
        return null;
    }
}

