/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import jdk.Profile+Annotation;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.FromByteCode;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
@I
@Profile+Annotation(value=1)
public class ArrayDeque<@KeyForBottom E>
extends AbstractCollection<E>
implements Deque<E>,
Cloneable,
Serializable {
    transient Object[] elements;
    transient int head;
    transient int tail;
    private static final int MIN_INITIAL_CAPACITY = 8;
    private static final @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable long serialVersionUID = 2340985798034038923L;

    private void allocateElements(int var1);

    private void doubleCapacity();

    private <T> T[] copyElements(T[] var1);

    @FromByteCode
    @FromByteCode
    public ArrayDeque();

    @FromByteCode
    @FromByteCode
    public ArrayDeque(@UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int var1);

    @FromByteCode
    @FromByteCode
    public @PolyRead ArrayDeque(@UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @PolyRead Collection<@KeyForBottom @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable ? extends E> var1);

    @Override
    @FromByteCode
    @FromByteCode
    public void addFirst(@Mutable ArrayDeque<E> this, E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public void addLast(@Mutable ArrayDeque<E> this, E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean offerFirst(@Mutable ArrayDeque<E> this, E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean offerLast(@Mutable ArrayDeque<E> this, E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public E removeFirst(@Mutable ArrayDeque<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public E removeLast(@Mutable ArrayDeque<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E pollFirst(@Mutable ArrayDeque<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E pollLast(@Mutable ArrayDeque<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public E getFirst(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public E getLast(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E peekFirst(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E peekLast(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean removeFirstOccurrence(@Mutable ArrayDeque<E> this, @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean removeLastOccurrence(@Mutable ArrayDeque<E> this, @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean add(@Mutable ArrayDeque<E> this, E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean offer(@Mutable ArrayDeque<E> this, E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public E remove(@Mutable ArrayDeque<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E poll(@Mutable ArrayDeque<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public E element(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E peek(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public void push(@Mutable ArrayDeque<E> this, E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public E pop(@Mutable ArrayDeque<E> this);

    private void checkInvariants();

    private boolean delete(int var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int size(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    @EnsuresNonNullIf(result=false, expression={"peek()", "peekFirst()", "peekLast()", "poll()", "pollFirst()", "pollLast()"})
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean isEmpty(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @I @PolyRead Iterator<E> iterator(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @I @PolyRead Iterator<E> descendingIterator(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean contains(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this, @Nullable @UnknownKeyFor @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean remove(@Mutable ArrayDeque<E> this, @Nullable @UnknownKeyFor @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public void clear(@Mutable ArrayDeque<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable Object @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable [] toArray(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public <T> @Nullable T @PolyNull @UnknownKeyFor @Initialized @org.checkerframework.checker.javari.qual.Mutable [] toArray(@org.checkerframework.checker.igj.qual.ReadOnly ArrayDeque<E> this, T @PolyNull @UnknownKeyFor @Initialized @org.checkerframework.checker.javari.qual.Mutable [] var1);

    @SideEffectFree
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @I(value="N") @org.checkerframework.checker.javari.qual.Mutable ArrayDeque<E> clone();

    private void writeObject(ObjectOutputStream var1) throws IOException;

    private void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    @Override
    public Spliterator<E> spliterator();

    static;

    private class DeqIterator
    implements Iterator<E> {
        int cursor;
        int remaining;
        int lastRet;

        DeqIterator() {
            this.remaining = ArrayDeque.this.size();
            this.lastRet = -1;
            this.cursor = ArrayDeque.this.head;
        }

        @Override
        public final boolean hasNext() {
            return this.remaining > 0;
        }

        @Override
        public E next() {
            if (this.remaining <= 0) {
                throw new NoSuchElementException();
            }
            Object[] es = ArrayDeque.this.elements;
            Object e = ArrayDeque.nonNullElementAt((Object[])es, (int)this.cursor);
            this.lastRet = this.cursor;
            this.cursor = ArrayDeque.inc((int)this.lastRet, (int)es.length);
            --this.remaining;
            return e;
        }

        void postDelete(boolean leftShifted) {
            if (leftShifted) {
                this.cursor = ArrayDeque.dec((int)this.cursor, (int)ArrayDeque.this.elements.length);
            }
        }

        @Override
        public final void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.postDelete(ArrayDeque.this.delete(this.lastRet));
            this.lastRet = -1;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            int to;
            Objects.requireNonNull(action);
            int r = this.remaining;
            if (r <= 0) {
                return;
            }
            this.remaining = 0;
            Object[] es = ArrayDeque.this.elements;
            if (es[this.cursor] == null || ArrayDeque.sub((int)ArrayDeque.this.tail, (int)this.cursor, (int)es.length) != r) {
                throw new ConcurrentModificationException();
            }
            int i = this.cursor;
            int end = ArrayDeque.this.tail;
            int n = to = i <= end ? end : es.length;
            while (true) {
                if (i < to) {
                    action.accept(ArrayDeque.elementAt((Object[])es, (int)i));
                    ++i;
                    continue;
                }
                if (to == end) {
                    if (end != ArrayDeque.this.tail) {
                        throw new ConcurrentModificationException();
                    }
                    break;
                }
                i = 0;
                to = end;
            }
            this.lastRet = ArrayDeque.dec((int)end, (int)es.length);
        }
    }

    private class DescendingIterator
    extends DeqIterator {
        DescendingIterator() {
            this.cursor = ArrayDeque.dec((int)ArrayDeque.this.tail, (int)ArrayDeque.this.elements.length);
        }

        @Override
        public final E next() {
            if (this.remaining <= 0) {
                throw new NoSuchElementException();
            }
            Object[] es = ArrayDeque.this.elements;
            Object e = ArrayDeque.nonNullElementAt((Object[])es, (int)this.cursor);
            this.lastRet = this.cursor;
            this.cursor = ArrayDeque.dec((int)this.lastRet, (int)es.length);
            --this.remaining;
            return e;
        }

        @Override
        void postDelete(boolean leftShifted) {
            if (!leftShifted) {
                this.cursor = ArrayDeque.inc((int)this.cursor, (int)ArrayDeque.this.elements.length);
            }
        }

        @Override
        public final void forEachRemaining(Consumer<? super E> action) {
            int to;
            Objects.requireNonNull(action);
            int r = this.remaining;
            if (r <= 0) {
                return;
            }
            this.remaining = 0;
            Object[] es = ArrayDeque.this.elements;
            if (es[this.cursor] == null || ArrayDeque.sub((int)this.cursor, (int)ArrayDeque.this.head, (int)es.length) + 1 != r) {
                throw new ConcurrentModificationException();
            }
            int i = this.cursor;
            int end = ArrayDeque.this.head;
            int n = to = i >= end ? end : 0;
            while (true) {
                if (i > to - 1) {
                    action.accept(ArrayDeque.elementAt((Object[])es, (int)i));
                    --i;
                    continue;
                }
                if (to == end) {
                    if (end != ArrayDeque.this.head) {
                        throw new ConcurrentModificationException();
                    }
                    break;
                }
                i = es.length - 1;
                to = end;
            }
            this.lastRet = end;
        }
    }

    final class DeqSpliterator
    implements Spliterator<E> {
        private int fence;
        private int cursor;

        DeqSpliterator() {
            this.fence = -1;
        }

        DeqSpliterator(int origin, int fence) {
            this.cursor = origin;
            this.fence = fence;
        }

        private int getFence() {
            int t = this.fence;
            if (t < 0) {
                t = this.fence = ArrayDeque.this.tail;
                this.cursor = ArrayDeque.this.head;
            }
            return t;
        }

        public DeqSpliterator trySplit() {
            DeqSpliterator deqSpliterator;
            Object[] es = ArrayDeque.this.elements;
            int i = this.cursor;
            int n = ArrayDeque.sub((int)this.getFence(), (int)i, (int)es.length) >> 1;
            if (n <= 0) {
                deqSpliterator = null;
            } else {
                this.cursor = ArrayDeque.inc((int)i, (int)n, (int)es.length);
                DeqSpliterator deqSpliterator2 = new DeqSpliterator(i, this.cursor);
                deqSpliterator = deqSpliterator2;
            }
            return deqSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int end = this.getFence();
            int cursor = this.cursor;
            Object[] es = ArrayDeque.this.elements;
            if (cursor != end) {
                int to;
                this.cursor = end;
                if (es[cursor] == null || es[ArrayDeque.dec((int)end, (int)es.length)] == null) {
                    throw new ConcurrentModificationException();
                }
                int i = cursor;
                int n = to = i <= end ? end : es.length;
                while (true) {
                    if (i < to) {
                        action.accept(ArrayDeque.elementAt((Object[])es, (int)i));
                        ++i;
                        continue;
                    }
                    if (to == end) break;
                    i = 0;
                    to = end;
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            int i;
            Objects.requireNonNull(action);
            Object[] es = ArrayDeque.this.elements;
            if (this.fence < 0) {
                this.fence = ArrayDeque.this.tail;
                this.cursor = ArrayDeque.this.head;
            }
            if ((i = this.cursor) == this.fence) {
                return false;
            }
            Object e = ArrayDeque.nonNullElementAt((Object[])es, (int)i);
            this.cursor = ArrayDeque.inc((int)i, (int)es.length);
            action.accept(e);
            return true;
        }

        @Override
        public long estimateSize() {
            return ArrayDeque.sub((int)this.getFence(), (int)this.cursor, (int)ArrayDeque.this.elements.length);
        }

        @Override
        public int characteristics() {
            return 16720;
        }
    }
}

