/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.exec.SystemExitManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.GeneratorAdapter;

public class BlockExitTransformer
implements ClassFileTransformer {
    private final URLClassLoader classLoader;
    private final Log logger;

    BlockExitTransformer(URLClassLoader classLoader, Log logger) {
        this.classLoader = classLoader;
        this.logger = logger;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            ClassReader reader = new ClassReader(classfileBuffer);
            ClassWriter writer = this.createClassWriter();
            SystemExitOverrideVisitor visitor = new SystemExitOverrideVisitor((ClassVisitor)writer);
            reader.accept((ClassVisitor)visitor, 8);
            return writer.toByteArray();
        }
        catch (RuntimeException re) {
            this.logger.warn((CharSequence)("Unable to transform class " + className + " : " + re.getMessage()));
            return null;
        }
    }

    private ClassWriter createClassWriter() {
        return new ClassWriter(2){

            protected ClassLoader getClassLoader() {
                return BlockExitTransformer.this.classLoader;
            }
        };
    }

    public void close() throws IOException {
        this.classLoader.close();
    }

    private static class SystemExitOverrideVisitor
    extends ClassVisitor {
        private static final String SYSTEM_REPLACEMENT = SystemExitManager.class.getName().replace('.', '/');

        private SystemExitOverrideVisitor(ClassVisitor visitor) {
            super(589824, visitor);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            return new GeneratorAdapter(589824, super.visitMethod(access, name, descriptor, signature, exceptions), access, name, descriptor){

                public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                    if (owner.equals("java/lang/System") && name.equals("exit")) {
                        this.mv.visitMethodInsn(opcode, SYSTEM_REPLACEMENT, name, descriptor, isInterface);
                    } else {
                        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                    }
                }
            };
        }
    }
}

