/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.index.sweepline.SweepLineIndex;
import com.vividsolutions.jts.index.sweepline.SweepLineInterval;
import com.vividsolutions.jts.index.sweepline.SweepLineOverlapAction;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class SweeplineNestedRingTester {
    private GeometryGraph graph;
    private List rings = new ArrayList();
    private SweepLineIndex sweepLine;
    private Coordinate nestedPt = null;

    public SweeplineNestedRingTester(GeometryGraph graph) {
        this.graph = graph;
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public void add(LinearRing ring) {
        this.rings.add(ring);
    }

    public boolean isNonNested() {
        this.buildIndex();
        OverlapAction action = new OverlapAction();
        this.sweepLine.computeOverlaps(action);
        return action.isNonNested;
    }

    private void buildIndex() {
        this.sweepLine = new SweepLineIndex();
        for (int i = 0; i < this.rings.size(); ++i) {
            LinearRing ring = (LinearRing)this.rings.get(i);
            Envelope env = ring.getEnvelopeInternal();
            SweepLineInterval sweepInt = new SweepLineInterval(env.getMinX(), env.getMaxX(), ring);
            this.sweepLine.add(sweepInt);
        }
    }

    private boolean isInside(LinearRing innerRing, LinearRing searchRing) {
        Coordinate[] innerRingPts = innerRing.getCoordinates();
        Coordinate[] searchRingPts = searchRing.getCoordinates();
        if (!innerRing.getEnvelopeInternal().intersects(searchRing.getEnvelopeInternal())) {
            return false;
        }
        Coordinate innerRingPt = IsValidOp.findPtNotNode(innerRingPts, searchRing, this.graph);
        Assert.isTrue(innerRingPt != null, "Unable to find a ring point not a node of the search ring");
        boolean isInside = CGAlgorithms.isPointInRing(innerRingPt, searchRingPts);
        if (isInside) {
            this.nestedPt = innerRingPt;
            return true;
        }
        return false;
    }

    class OverlapAction
    implements SweepLineOverlapAction {
        boolean isNonNested = true;

        OverlapAction() {
        }

        @Override
        public void overlap(SweepLineInterval s0, SweepLineInterval s1) {
            LinearRing searchRing;
            LinearRing innerRing = (LinearRing)s0.getItem();
            if (innerRing == (searchRing = (LinearRing)s1.getItem())) {
                return;
            }
            if (SweeplineNestedRingTester.this.isInside(innerRing, searchRing)) {
                this.isNonNested = false;
            }
        }
    }
}

