/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper.shapefileParser.shapes;

import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.datasyslab.geospark.formatMapper.shapefileParser.shapes.DbfFileReader;
import org.datasyslab.geospark.formatMapper.shapefileParser.shapes.PrimitiveShape;
import org.datasyslab.geospark.formatMapper.shapefileParser.shapes.ShapeFileReader;
import org.datasyslab.geospark.formatMapper.shapefileParser.shapes.ShapeKey;

public class CombineShapeReader
extends RecordReader<ShapeKey, PrimitiveShape> {
    private FileSplit shpSplit = null;
    private FileSplit shxSplit = null;
    private FileSplit dbfSplit = null;
    private ShapeFileReader shapeFileReader = null;
    private DbfFileReader dbfFileReader = null;
    private static final String DBF_SUFFIX = "dbf";
    private static final String SHP_SUFFIX = "shp";
    private static final String SHX_SUFFIX = "shx";
    private PrimitiveShape value = null;
    private boolean hasDbf = false;
    private boolean hasNextDbf = false;

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        CombineFileSplit fileSplit = (CombineFileSplit)split;
        Path[] paths = fileSplit.getPaths();
        for (int i = 0; i < paths.length; ++i) {
            String suffix = FilenameUtils.getExtension((String)paths[i].toString());
            if (suffix.equals(SHP_SUFFIX)) {
                this.shpSplit = new FileSplit(paths[i], fileSplit.getOffset(i), fileSplit.getLength(i), fileSplit.getLocations());
                continue;
            }
            if (suffix.equals(SHX_SUFFIX)) {
                this.shxSplit = new FileSplit(paths[i], fileSplit.getOffset(i), fileSplit.getLength(i), fileSplit.getLocations());
                continue;
            }
            if (!suffix.equals(DBF_SUFFIX)) continue;
            this.dbfSplit = new FileSplit(paths[i], fileSplit.getOffset(i), fileSplit.getLength(i), fileSplit.getLocations());
        }
        if (this.shpSplit == null) {
            throw new IOException("Can't find .shp file.");
        }
        this.shapeFileReader = new ShapeFileReader();
        this.shapeFileReader.initialize((InputSplit)this.shpSplit, context);
        if (this.dbfSplit != null) {
            this.dbfFileReader = new DbfFileReader();
            this.dbfFileReader.initialize((InputSplit)this.dbfSplit, context);
            this.hasDbf = true;
        } else {
            this.hasDbf = false;
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (!this.hasDbf) {
            return this.shapeFileReader.nextKeyValue();
        }
        boolean hasNextShp = this.shapeFileReader.nextKeyValue();
        this.hasNextDbf = this.dbfFileReader.nextKeyValue();
        if (hasNextShp && !this.hasNextDbf) {
            Exception e = new Exception("shape record loses attributes in .dbf file at ID=" + this.shapeFileReader.getCurrentKey().getIndex());
            e.printStackTrace();
        } else if (!hasNextShp && this.hasNextDbf) {
            Exception e = new Exception("Redundant attributes in .dbf exists");
            e.printStackTrace();
        }
        return hasNextShp;
    }

    public ShapeKey getCurrentKey() throws IOException, InterruptedException {
        return this.shapeFileReader.getCurrentKey();
    }

    public PrimitiveShape getCurrentValue() throws IOException, InterruptedException {
        this.value = new PrimitiveShape();
        this.value.setPrimitiveRecord(this.shapeFileReader.getCurrentValue());
        if (this.hasDbf && this.hasNextDbf) {
            this.value.setPrimitiveAttribute(this.dbfFileReader.getCurrentValue());
        }
        return this.value;
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.shapeFileReader.getProgress();
    }

    public void close() throws IOException {
        this.shapeFileReader.close();
    }
}

