/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.spatialOperator;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.datasyslab.geospark.knnJudgement.GeometryDistanceComparator;
import org.datasyslab.geospark.knnJudgement.KnnJudgement;
import org.datasyslab.geospark.knnJudgement.KnnJudgementUsingIndex;
import org.datasyslab.geospark.spatialRDD.LineStringRDD;
import org.datasyslab.geospark.spatialRDD.PointRDD;
import org.datasyslab.geospark.spatialRDD.PolygonRDD;
import org.datasyslab.geospark.spatialRDD.RectangleRDD;
import org.datasyslab.geospark.utils.CRSTransformation;

public class KNNQuery
implements Serializable {
    public static List<Point> SpatialKnnQuery(PointRDD spatialRDD, Point originalQueryWindow, Integer k, boolean useIndex) {
        Point queryCenter = originalQueryWindow;
        if (spatialRDD.getCRStransformation()) {
            queryCenter = CRSTransformation.Transform(spatialRDD.getSourceEpsgCode(), spatialRDD.getTargetEpgsgCode(), originalQueryWindow);
        }
        if (useIndex) {
            if (spatialRDD.indexedRawRDD == null) {
                throw new NullPointerException("Need to invoke buildIndex() first, indexedRDDNoId is null");
            }
            JavaRDD tmp = spatialRDD.indexedRawRDD.mapPartitions((FlatMapFunction)new KnnJudgementUsingIndex(queryCenter, k));
            List result = tmp.takeOrdered(k.intValue(), (Comparator)new GeometryDistanceComparator(queryCenter, true));
            ArrayList<Point> geometryResult = new ArrayList<Point>();
            for (Object spatialObject : result) {
                geometryResult.add((Point)spatialObject);
            }
            return geometryResult;
        }
        JavaRDD tmp = spatialRDD.getRawSpatialRDD().mapPartitions((FlatMapFunction)new KnnJudgement(queryCenter, k));
        List result = tmp.takeOrdered(k.intValue(), (Comparator)new GeometryDistanceComparator(queryCenter, true));
        ArrayList<Point> geometryResult = new ArrayList<Point>();
        for (Object spatialObject : result) {
            geometryResult.add((Point)spatialObject);
        }
        return geometryResult;
    }

    public static List<Polygon> SpatialKnnQuery(RectangleRDD spatialRDD, Point originalQueryWindow, Integer k, boolean useIndex) {
        Point queryCenter = originalQueryWindow;
        if (spatialRDD.getCRStransformation()) {
            queryCenter = CRSTransformation.Transform(spatialRDD.getSourceEpsgCode(), spatialRDD.getTargetEpgsgCode(), originalQueryWindow);
        }
        if (useIndex) {
            if (spatialRDD.indexedRawRDD == null) {
                throw new NullPointerException("Need to invoke buildIndex() first, indexedRDDNoId is null");
            }
            JavaRDD tmp = spatialRDD.indexedRawRDD.mapPartitions((FlatMapFunction)new KnnJudgementUsingIndex(queryCenter, k));
            List result = tmp.takeOrdered(k.intValue(), (Comparator)new GeometryDistanceComparator(queryCenter, true));
            ArrayList<Polygon> geometryResult = new ArrayList<Polygon>();
            for (Object spatialObject : result) {
                geometryResult.add((Polygon)spatialObject);
            }
            return geometryResult;
        }
        JavaRDD tmp = spatialRDD.getRawSpatialRDD().mapPartitions((FlatMapFunction)new KnnJudgement(queryCenter, k));
        List result = tmp.takeOrdered(k.intValue(), (Comparator)new GeometryDistanceComparator(queryCenter, true));
        ArrayList<Polygon> geometryResult = new ArrayList<Polygon>();
        for (Object spatialObject : result) {
            geometryResult.add((Polygon)spatialObject);
        }
        return geometryResult;
    }

    public static List<Polygon> SpatialKnnQuery(PolygonRDD spatialRDD, Point originalQueryWindow, Integer k, boolean useIndex) {
        Point queryCenter = originalQueryWindow;
        if (spatialRDD.getCRStransformation()) {
            queryCenter = CRSTransformation.Transform(spatialRDD.getSourceEpsgCode(), spatialRDD.getTargetEpgsgCode(), originalQueryWindow);
        }
        if (useIndex) {
            if (spatialRDD.indexedRawRDD == null) {
                throw new NullPointerException("Need to invoke buildIndex() first, indexedRDDNoId is null");
            }
            JavaRDD tmp = spatialRDD.indexedRawRDD.mapPartitions((FlatMapFunction)new KnnJudgementUsingIndex(queryCenter, k));
            List result = tmp.takeOrdered(k.intValue(), (Comparator)new GeometryDistanceComparator(queryCenter, true));
            ArrayList<Polygon> geometryResult = new ArrayList<Polygon>();
            for (Object spatialObject : result) {
                geometryResult.add((Polygon)spatialObject);
            }
            return geometryResult;
        }
        JavaRDD tmp = spatialRDD.getRawSpatialRDD().mapPartitions((FlatMapFunction)new KnnJudgement(queryCenter, k));
        List result = tmp.takeOrdered(k.intValue(), (Comparator)new GeometryDistanceComparator(queryCenter, true));
        ArrayList<Polygon> geometryResult = new ArrayList<Polygon>();
        for (Object spatialObject : result) {
            geometryResult.add((Polygon)spatialObject);
        }
        return geometryResult;
    }

    public static List<LineString> SpatialKnnQuery(LineStringRDD spatialRDD, Point originalQueryWindow, Integer k, boolean useIndex) {
        Point queryCenter = originalQueryWindow;
        if (spatialRDD.getCRStransformation()) {
            queryCenter = CRSTransformation.Transform(spatialRDD.getSourceEpsgCode(), spatialRDD.getTargetEpgsgCode(), originalQueryWindow);
        }
        if (useIndex) {
            if (spatialRDD.indexedRawRDD == null) {
                throw new NullPointerException("Need to invoke buildIndex() first, indexedRDDNoId is null");
            }
            JavaRDD tmp = spatialRDD.indexedRawRDD.mapPartitions((FlatMapFunction)new KnnJudgementUsingIndex(queryCenter, k));
            List result = tmp.takeOrdered(k.intValue(), (Comparator)new GeometryDistanceComparator(queryCenter, true));
            ArrayList<LineString> geometryResult = new ArrayList<LineString>();
            for (Object spatialObject : result) {
                geometryResult.add((LineString)spatialObject);
            }
            return geometryResult;
        }
        JavaRDD tmp = spatialRDD.getRawSpatialRDD().mapPartitions((FlatMapFunction)new KnnJudgement(queryCenter, k));
        List result = tmp.takeOrdered(k.intValue(), (Comparator)new GeometryDistanceComparator(queryCenter, true));
        ArrayList<LineString> geometryResult = new ArrayList<LineString>();
        for (Object spatialObject : result) {
            geometryResult.add((LineString)spatialObject);
        }
        return geometryResult;
    }
}

