/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.spatialPartitioning;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.triangulate.VoronoiDiagramBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class VoronoiPartitioning
implements Serializable {
    List<Envelope> grids = new ArrayList<Envelope>();

    public VoronoiPartitioning(List SampleList, Envelope boundary, int partitions) throws Exception {
        Coordinate coordinate;
        Envelope envelope;
        int i;
        GeometryFactory fact = new GeometryFactory();
        ArrayList<Point> subSampleList = new ArrayList<Point>();
        if (SampleList.get(0) instanceof Envelope) {
            for (i = 0; i < SampleList.size(); i += SampleList.size() / partitions) {
                envelope = (Envelope)SampleList.get(i);
                coordinate = new Coordinate((envelope.getMinX() + envelope.getMaxX()) / 2.0, (envelope.getMinY() + envelope.getMaxY()) / 2.0);
                subSampleList.add(fact.createPoint(coordinate));
            }
        } else if (SampleList.get(0) instanceof Geometry) {
            for (i = 0; i < SampleList.size(); i += SampleList.size() / partitions) {
                envelope = ((Geometry)SampleList.get(i)).getEnvelopeInternal();
                coordinate = new Coordinate((envelope.getMinX() + envelope.getMaxX()) / 2.0, (envelope.getMinY() + envelope.getMaxY()) / 2.0);
                subSampleList.add(fact.createPoint(coordinate));
            }
        } else {
            throw new Exception("[VoronoiPartitioning][Constrcutor] Unsupported spatial object type");
        }
        MultiPoint mp = fact.createMultiPoint(subSampleList.toArray(new Point[subSampleList.size()]));
        VoronoiDiagramBuilder voronoiBuilder = new VoronoiDiagramBuilder();
        voronoiBuilder.setSites(mp);
        Geometry voronoiDiagram = voronoiBuilder.getDiagram(fact);
        for (int i2 = 0; i2 < voronoiDiagram.getNumGeometries(); ++i2) {
            Polygon poly = (Polygon)voronoiDiagram.getGeometryN(i2);
            this.grids.add(poly.getEnvelopeInternal());
        }
    }

    public List<Envelope> getGrids() {
        return this.grids;
    }
}

