/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.spatialPartitioning.quadtree;

import com.vividsolutions.jts.geom.Envelope;
import java.io.Serializable;

public class QuadRectangle
implements Serializable {
    public double x;
    public double y;
    public double width;
    public double height;
    public Integer partitionId = -1;

    public QuadRectangle(Envelope envelope) {
        this.x = envelope.getMinX();
        this.y = envelope.getMinY();
        this.width = envelope.getWidth();
        this.height = envelope.getHeight();
    }

    public QuadRectangle(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public boolean contains(int x, int y) {
        return this.width > 0.0 && this.height > 0.0 && (double)x >= this.x && (double)x <= this.x + this.width && (double)y >= this.y && (double)y <= this.y + this.height;
    }

    public boolean contains(QuadRectangle r) {
        return this.width > 0.0 && this.height > 0.0 && r.width > 0.0 && r.height > 0.0 && r.x >= this.x && r.x + r.width <= this.x + this.width && r.y >= this.y && r.y + r.height <= this.y + this.height;
    }

    public int getUniqueId() {
        return this.hashCode();
    }

    public Envelope getEnvelope() {
        return new Envelope(this.x, this.x + this.width, this.y, this.y + this.height);
    }

    public String toString() {
        return "x: " + this.x + " y: " + this.y + " w: " + this.width + " h: " + this.height + " PartitionId: " + this.partitionId;
    }

    public int hashCode() {
        String stringId = "" + this.x + this.y + this.width + this.height;
        return stringId.hashCode();
    }
}

