/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.BoundsVisitor;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.CollectionFeatureMemberFilterVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;

public class Collection_BoundsFunction
extends FunctionExpressionImpl {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.filter.function");
    FeatureCollection<FeatureType, Feature> previousFeatureCollection = null;
    Object bounds = null;
    public static FunctionName NAME = new FunctionNameImpl("Collection_Bounds", FunctionNameImpl.parameter("bounds", Object.class), FunctionNameImpl.parameter("geometry", Geometry.class));

    public Collection_BoundsFunction() {
        super(NAME);
    }

    static CalcResult calculateBounds(FeatureCollection<? extends FeatureType, ? extends Feature> collection) throws IllegalFilterException, IOException {
        BoundsVisitor boundsVisitor = new BoundsVisitor();
        collection.accepts(boundsVisitor, null);
        return boundsVisitor.getResult();
    }

    public void setExpression(Expression e) {
        this.setParameters((List)Collections.singletonList(e));
    }

    public void setParameters(List args) {
        if (args.size() != 1) {
            throw new IllegalArgumentException("Require a single argument for " + this.getName());
        }
        Expression expr = (Expression)args.get(0);
        expr = (Expression)expr.accept(new CollectionFeatureMemberFilterVisitor(), null);
        args.set(0, expr);
        super.setParameters(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Object feature) {
        FeatureCollection featureCollection;
        if (feature == null) {
            return new Integer(0);
        }
        FeatureCollection featureCollection2 = featureCollection = (FeatureCollection)feature;
        synchronized (featureCollection2) {
            if (featureCollection != this.previousFeatureCollection) {
                this.previousFeatureCollection = featureCollection;
                this.bounds = null;
                try {
                    CalcResult result = Collection_BoundsFunction.calculateBounds(featureCollection);
                    if (result != null) {
                        this.bounds = result.getValue();
                    }
                }
                catch (IllegalFilterException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
            }
        }
        return this.bounds;
    }
}

