/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.wms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.geoserver.gwc.GWC;
import org.geoserver.wms.ExtendedCapabilitiesProvider;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geotools.util.Version;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeType;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingExtendedCapabilitiesProvider
implements ExtendedCapabilitiesProvider {
    private final GWC gwc;

    public CachingExtendedCapabilitiesProvider(GWC gwc) {
        this.gwc = gwc;
    }

    public String[] getSchemaLocations(String schemaBaseURL) {
        return new String[0];
    }

    public List<String> getVendorSpecificCapabilitiesRoots(GetCapabilitiesRequest request) {
        if (this.isTiled(request)) {
            return Collections.singletonList("TileSet*");
        }
        return Collections.emptyList();
    }

    private boolean isTiled(GetCapabilitiesRequest request) {
        return Boolean.valueOf((String)request.getRawKvp().get("TILED"));
    }

    public List<String> getVendorSpecificCapabilitiesChildDecls(GetCapabilitiesRequest request) {
        if (this.isTiled(request)) {
            ArrayList<String> wmscElements = new ArrayList<String>();
            wmscElements.add("<!ELEMENT TileSet (SRS, BoundingBox?, Resolutions, Width, Height, Format, Layers*, Styles*) >");
            wmscElements.add("<!ELEMENT Resolutions (#PCDATA) >");
            wmscElements.add("<!ELEMENT Width (#PCDATA) >");
            wmscElements.add("<!ELEMENT Height (#PCDATA) >");
            wmscElements.add("<!ELEMENT Layers (#PCDATA) >");
            wmscElements.add("<!ELEMENT Styles (#PCDATA) >");
            return wmscElements;
        }
        return Collections.emptyList();
    }

    public void registerNamespaces(NamespaceSupport namespaces) {
    }

    public void encode(ExtendedCapabilitiesProvider.Translator tx, WMSInfo wms, GetCapabilitiesRequest request) throws IOException {
        Version version = WMS.version((String)request.getVersion(), (boolean)true);
        if (!WMS.VERSION_1_1_1.equals((Object)version) || !this.isTiled(request)) {
            return;
        }
        List<TileLayer> tileLayers = this.gwc.getLayers(request.getNamespace());
        for (TileLayer layer : tileLayers) {
            Collection layerGrids = layer.getGridSubsets().values();
            for (GridSubset grid : layerGrids) {
                for (MimeType mime : layer.getMimeTypes()) {
                    this.vendorSpecificTileset(tx, layer, grid, mime.getFormat());
                }
            }
        }
    }

    private void vendorSpecificTileset(ExtendedCapabilitiesProvider.Translator tx, TileLayer layer, GridSubset grid, String format) {
        String srsStr = grid.getSRS().toString();
        StringBuilder resolutionsStr = new StringBuilder();
        double[] res = grid.getResolutions();
        int i = 0;
        while (i < res.length) {
            resolutionsStr.append(String.valueOf(Double.toString(res[i])) + " ");
            ++i;
        }
        String[] bs = this.boundsPrep(grid.getCoverageBestFitBounds());
        tx.start("TileSet");
        tx.start("SRS");
        tx.chars(srsStr);
        tx.end("SRS");
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "SRS", "SRS", "", srsStr);
        atts.addAttribute("", "minx", "minx", "", bs[0]);
        atts.addAttribute("", "miny", "miny", "", bs[1]);
        atts.addAttribute("", "maxx", "maxx", "", bs[2]);
        atts.addAttribute("", "maxy", "maxy", "", bs[3]);
        tx.start("BoundingBox", (Attributes)atts);
        tx.end("BoundingBox");
        tx.start("Resolutions");
        tx.chars(resolutionsStr.toString());
        tx.end("Resolutions");
        tx.start("Width");
        tx.chars(String.valueOf(grid.getTileWidth()));
        tx.end("Width");
        tx.start("Height");
        tx.chars(String.valueOf(grid.getTileHeight()));
        tx.end("Height");
        tx.start("Format");
        tx.chars(format);
        tx.end("Format");
        tx.start("Layers");
        tx.chars(layer.getName());
        tx.end("Layers");
        tx.start("Styles");
        tx.end("Styles");
        tx.end("TileSet");
    }

    String[] boundsPrep(BoundingBox bbox) {
        String[] bs = new String[]{Double.toString(bbox.getMinX()), Double.toString(bbox.getMinY()), Double.toString(bbox.getMaxX()), Double.toString(bbox.getMaxY())};
        return bs;
    }
}

